/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.opentelemetry;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.HeaderField;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Arrays;

public class HTTPTraceContextUtil {
    public static TextMapGetter<Exchange> getContextFromRequestHeader() {
        return new TextMapGetter<Exchange>(){

            public String get(Exchange carrier, String key) {
                return carrier.getRequest().getHeader().getFirstValue(key);
            }

            public Iterable<String> keys(Exchange carrier) {
                return Arrays.stream(carrier.getRequest().getHeader().getAllHeaderFields()).map(HeaderField::toString).toList();
            }
        };
    }

    public static TextMapSetter<Exchange> setContextInHeader() {
        return (carrier, key, value) -> carrier.getRequest().getHeader().add(key, value);
    }
}

