/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.opentelemetry;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.interceptor.opentelemetry.exporter.OtelExporter;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.ResourceAttributes;

public class OpenTelemetryConfigurator {
    public static OpenTelemetry openTelemetry(String serviceName, OtelExporter exporter, double sampleRate) {
        SdkTracerProvider provider = OpenTelemetryConfigurator.getSdkTracerProvider(serviceName, exporter, sampleRate);
        OpenTelemetrySdk openTelemetry = OpenTelemetryConfigurator.getGlobalOpenTelemetry(provider);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkTracerProvider)provider).close()));
        return openTelemetry;
    }

    private static OpenTelemetrySdk getGlobalOpenTelemetry(SdkTracerProvider sdkTracerProvider) {
        return OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{W3CTraceContextPropagator.getInstance(), W3CBaggagePropagator.getInstance()}))).build();
    }

    private static SdkTracerProvider getSdkTracerProvider(String serviceName, OtelExporter exporter, double sampleRate) {
        return SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)exporter.get()).build()).setSampler(Sampler.traceIdRatioBased((double)sampleRate)).setResource(Resource.getDefault().toBuilder().put(ResourceAttributes.SERVICE_NAME, (Object)serviceName).put(ResourceAttributes.SERVICE_VERSION, (Object)Constants.VERSION).build()).build();
    }
}

