/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.opentelemetry;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.opentelemetry.HTTPTraceContextUtil;
import com.predic8.membrane.core.interceptor.opentelemetry.OpenTelemetryConfigurator;
import com.predic8.membrane.core.interceptor.opentelemetry.exporter.OtelExporter;
import com.predic8.membrane.core.interceptor.opentelemetry.exporter.OtlpExporter;
import com.predic8.membrane.core.openapi.serviceproxy.APIProxy;
import com.predic8.membrane.core.openapi.serviceproxy.OpenAPIRecord;
import com.predic8.membrane.core.proxies.Proxy;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="openTelemetry")
public class OpenTelemetryInterceptor
extends AbstractInterceptor {
    private double sampleRate = 1.0;
    private OtelExporter exporter = new OtlpExporter();
    private OpenTelemetry otel;
    private Tracer tracer;
    private boolean logBody = false;
    private static final Logger log = LoggerFactory.getLogger(OpenTelemetryInterceptor.class);

    @Override
    public void init() {
        super.init();
        this.otel = OpenTelemetryConfigurator.openTelemetry("Membrane", this.exporter, this.getSampleRate());
        this.tracer = this.otel.getTracer("MEMBRANE-TRACER");
    }

    public OpenTelemetryInterceptor() {
        this.name = "opentelemetry exporter";
    }

    @Override
    public String getShortDescription() {
        return "Exports OpenTelemetry data to a specified collector.";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + "<br/>Collector: " + this.exporter.getEndpointUrl();
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        this.startMembraneScope(exc, this.getExtractContext(exc), this.getSpanName(exc));
        Span span = OpenTelemetryInterceptor.getExchangeSpan(exc);
        OpenTelemetryInterceptor.setSpanHttpHeaderAttributes(exc.getRequest().getHeader(), span);
        if (this.logBody) {
            span.addEvent("Request", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"Request Body"), (Object)exc.getRequest().getBodyAsStringDecoded()));
        }
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        Span span = OpenTelemetryInterceptor.getExchangeSpan(exc);
        span.setStatus(this.getOtelStatusCode(exc));
        span.setAttribute("http.status_code", (long)exc.getResponse().getStatusCode());
        OpenTelemetryInterceptor.setSpanHttpHeaderAttributes(exc.getResponse().getHeader(), span);
        if (exc.getProxy() instanceof APIProxy) {
            this.setSpanOpenAPIAttributes(exc, span);
        }
        if (this.logBody) {
            span.addEvent("Response", Attributes.of((AttributeKey)AttributeKey.stringKey((String)"Response Body"), (Object)exc.getResponse().getBodyAsStringDecoded()));
        }
        span.addEvent("Close Exchange").end();
        return Outcome.CONTINUE;
    }

    private static Span getExchangeSpan(Exchange exc) {
        return exc.getProperty("span", Span.class);
    }

    private static void setSpanHttpHeaderAttributes(Header header, Span span) {
        for (HeaderField hf : header.getAllHeaderFields()) {
            span.setAttribute("http.header." + hf.getHeaderName().toString(), hf.getValue());
        }
    }

    private void setSpanOpenAPIAttributes(Exchange exc, Span span) {
        OpenAPIRecord record;
        try {
            record = exc.getProperty("OPENAPI_RECORD", OpenAPIRecord.class);
        }
        catch (ClassCastException e) {
            log.debug("No OpenAPI to report to OpenTelemetry.");
            return;
        }
        if (record != null) {
            span.setAttribute("openapi.title", record.getApi().getInfo().getTitle());
        }
    }

    private String getSpanName(Exchange exc) {
        return this.getProxyName(exc) + " " + exc.getRequest().getMethod() + " " + exc.getRequest().getUri();
    }

    private String getProxyName(Exchange exc) {
        Proxy r = exc.getProxy();
        return r.getName().isEmpty() ? r.getKey().getHost() + r.getKey().getPort() : r.getName();
    }

    private StatusCode getOtelStatusCode(Exchange exc) {
        return exc.getResponse().getStatusCode() >= 500 ? StatusCode.ERROR : StatusCode.OK;
    }

    private void startMembraneScope(Exchange exc, Context receivedContext, String spanName) {
        try (Scope ignore = receivedContext.makeCurrent();){
            Span membraneSpan = this.getMembraneSpan(spanName, "Initialize Exchange");
            try (Scope ignored = membraneSpan.makeCurrent();){
                this.setExchangeHeader(exc);
                exc.setProperty("span", membraneSpan);
            }
        }
    }

    private Span getMembraneSpan(String spanName, String eventName) {
        return this.tracer.spanBuilder(spanName).setSpanKind(SpanKind.INTERNAL).startSpan().addEvent(eventName);
    }

    private void setExchangeHeader(Exchange exc) {
        this.otel.getPropagators().getTextMapPropagator().inject(Context.current(), (Object)exc, HTTPTraceContextUtil.setContextInHeader());
    }

    private Context getExtractContext(Exchange exc) {
        return this.otel.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)exc, HTTPTraceContextUtil.getContextFromRequestHeader());
    }

    @MCAttribute
    public void setLogBody(boolean logBody) {
        this.logBody = logBody;
    }

    public boolean getLogBody() {
        return this.logBody;
    }

    @MCChildElement
    public void setExporter(OtelExporter exporter) {
        this.exporter = exporter;
    }

    public OtelExporter getExporter() {
        return this.exporter;
    }

    @MCAttribute
    public void setSampleRate(double sampleRate) {
        this.sampleRate = sampleRate;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }
}

