/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.opentelemetry.exporter;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.interceptor.addHeader;
import com.predic8.membrane.core.interceptor.opentelemetry.exporter.OtelExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@MCElement(name="otlpExporter", topLevel=false)
public class OtlpExporter
implements OtelExporter {
    private static final int TIMEOUT_SECONDS = 30;
    private String host = "localhost";
    private Integer port;
    private String path = "";
    private OtlpType transport = OtlpType.GRPC;
    private final List<addHeader> headers = new ArrayList<addHeader>();
    private boolean secured = false;

    @Override
    public String getEndpointUrl() {
        return String.format("%s://%s:%d%s", this.isSecured() ? "https" : "http", this.host, this.getProtocolPort(this.port, this.transport), this.getPathExtension());
    }

    private String getPathExtension() {
        if (this.path == "" && this.transport == OtlpType.HTTP) {
            return "/v1/traces";
        }
        return this.path;
    }

    private int getProtocolPort(Integer port, OtlpType trans) {
        if (port == null) {
            return switch (trans.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 4318;
                case 1 -> 4317;
            };
        }
        return port;
    }

    @Override
    public SpanExporter get() {
        String endpointUrl = this.getEndpointUrl();
        return this.createSpanExporter(endpointUrl, this.headers.stream().map(addHeader::asHeaderField).toList());
    }

    private SpanExporter createSpanExporter(String endpointUrl, List<HeaderField> headers) {
        switch (this.transport.ordinal()) {
            case 1: {
                return this.buildGrpcExporter(endpointUrl);
            }
            case 0: {
                return this.buildHttpExporter(endpointUrl, headers);
            }
        }
        throw new IllegalArgumentException("Unsupported transport type");
    }

    private OtlpGrpcSpanExporter buildGrpcExporter(String endpointUrl) {
        return OtlpGrpcSpanExporter.builder().setEndpoint(endpointUrl).setTimeout(30L, TimeUnit.SECONDS).build();
    }

    private OtlpHttpSpanExporter buildHttpExporter(String endpointUrl, List<HeaderField> headers) {
        OtlpHttpSpanExporterBuilder builder = OtlpHttpSpanExporter.builder().setEndpoint(endpointUrl).setTimeout(30L, TimeUnit.SECONDS);
        for (HeaderField header : headers) {
            builder.addHeader(header.getHeaderName().toString(), header.getValue());
        }
        return builder.build();
    }

    @MCChildElement
    public void setHeaders(List<addHeader> headers) {
        this.headers.addAll(headers);
    }

    @MCAttribute
    public void setTransport(String transport) {
        this.transport = OtlpType.fromString(transport);
    }

    @MCAttribute
    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    @MCAttribute
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    @MCAttribute
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    @MCAttribute
    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public List<addHeader> getHeaders() {
        return this.headers;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public static enum OtlpType {
        HTTP,
        GRPC;


        public String toString() {
            return this.name();
        }

        public static OtlpType fromString(String str) {
            for (OtlpType type : OtlpType.values()) {
                if (!type.name().equalsIgnoreCase(str)) continue;
                return type;
            }
            throw new IllegalArgumentException("Illegal type for OtlpExporter: " + str);
        }
    }
}

