/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.prometheus;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.openapi.serviceproxy.APIProxy;
import com.predic8.membrane.core.openapi.serviceproxy.ValidationStatsKey;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.SSLableProxy;
import com.predic8.membrane.core.proxies.TimeCollector;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="prometheus")
public class PrometheusInterceptor
extends AbstractInterceptor {
    static final Logger LOG = LoggerFactory.getLogger(PrometheusInterceptor.class);
    static volatile boolean issuedDuplicateRuleNameWarning = false;
    ConcurrentHashMap<String, String> names = new ConcurrentHashMap();
    Pattern ILLEGAL_FIRST_CHAR = Pattern.compile("^[^a-zA-Z_:]");
    Pattern ILLEGAL_CHARS = Pattern.compile("[^a-zA-Z0-9_:]");

    public PrometheusInterceptor() {
        this.name = "prometheus";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        Context ctx = new Context();
        this.buildPrometheusStyleResponse(ctx);
        exc.setResponse(Response.ok(ctx.sb.toString()).header("Content-Type", "text/plain; version=0.0.4").build());
        return Outcome.RETURN;
    }

    private void buildPrometheusStyleResponse(Context ctx) {
        ctx.resetAll();
        ctx.reset();
        for (Proxy r : this.router.getRuleManager().getRules()) {
            SSLableProxy sp;
            SSLContext sslib;
            if (!ctx.seenRules.add(this.prometheusCompatibleName(r.getName()))) {
                if (issuedDuplicateRuleNameWarning) continue;
                LOG.warn("The prometheus interceptor detected the same rule name more than once: {}", (Object)r.getName());
                issuedDuplicateRuleNameWarning = true;
                continue;
            }
            this.buildStatuscodeLines(ctx, r);
            this.buildBuckets(ctx, r);
            this.buildActive(ctx, r);
            if (r.isActive() && r instanceof SSLableProxy && (sslib = (sp = (SSLableProxy)r).getSslInboundContext()) != null) {
                this.buildSSLLines(ctx, r, sslib);
            }
            if (!(r instanceof APIProxy)) continue;
            this.buildOpenAPIValidatorLines(ctx, (APIProxy)r);
        }
        this.buildDuplicateRuleNameWarning(ctx, issuedDuplicateRuleNameWarning);
        ctx.collect();
    }

    private void buildOpenAPIValidatorLines(Context ctx, APIProxy proxy) {
        for (Map.Entry<ValidationStatsKey, Integer> e : proxy.getValidationStatisticCollector().getStats().entrySet()) {
            this.buildLine(ctx.s10, proxy.getName(), e.getValue().intValue(), e.getKey().getLabels(), "openapi_validation");
        }
    }

    private void buildLine(StringBuilder sb, String ruleName, long value, Map<String, String> labels, String postFix) {
        String prometheusName = this.prometheusCompatibleName("membrane_" + postFix);
        if (sb.isEmpty()) {
            sb.append("# TYPE ");
            sb.append(prometheusName);
            sb.append(" counter\n");
        }
        sb.append(prometheusName);
        sb.append("{rule=\"");
        sb.append(this.prometheusCompatibleName(ruleName));
        sb.append("\",");
        for (Map.Entry<String, String> e : labels.entrySet()) {
            sb.append(e.getKey());
            sb.append("=\"");
            sb.append(e.getValue());
            sb.append("\",");
        }
        sb.append("} ");
        sb.append(value);
        sb.append("\n");
    }

    private void buildSSLLines(Context ctx, Proxy r, SSLContext sslib) {
        boolean hasKeyAndCert = sslib.hasKeyAndCertificate();
        this.buildSSLLine(ctx.s7, r.getName(), sslib.getPrometheusContextTypeName(), "ssl_haskeyandcert", hasKeyAndCert ? 1L : 0L);
        if (hasKeyAndCert) {
            this.buildSSLLine(ctx.s8, r.getName(), sslib.getPrometheusContextTypeName(), "ssl_validfrom_ms", sslib.getValidFrom());
            this.buildSSLLine(ctx.s9, r.getName(), sslib.getPrometheusContextTypeName(), "ssl_validuntil_ms", sslib.getValidUntil());
        }
    }

    private void buildSSLLine(StringBuilder sb, String ruleName, String prometheusContextTypeName, String metric, long value) {
        String prometheusName = this.prometheusCompatibleName("membrane_" + metric);
        if (sb.isEmpty()) {
            sb.append("# TYPE ");
            sb.append(prometheusName);
            sb.append(" gauge\n");
        }
        sb.append(prometheusName);
        sb.append("{rule=\"");
        sb.append(this.prometheusCompatibleName(ruleName));
        sb.append("\",type=\"");
        sb.append(this.prometheusCompatibleName(prometheusContextTypeName));
        sb.append("\"} ");
        sb.append(value);
        sb.append("\n");
    }

    private void buildDuplicateRuleNameWarning(Context ctx, boolean hasDuplicateRuleName) {
        ctx.s6.append("# TYPE membrane_duplicate_rule_name gauge\n");
        this.buildLine(ctx.s6, "duplicate_rule_name", hasDuplicateRuleName ? 1L : 0L);
    }

    private void buildActive(Context ctx, Proxy r) {
        if (ctx.s6.isEmpty()) {
            ctx.s6.append("# TYPE membrane_rule_active gauge\n");
        }
        this.buildBucketLine(ctx.s6, r.getName(), "rule_active", r.isActive() ? 1L : 0L);
    }

    private void buildBuckets(Context ctx, Proxy proxy) {
        proxy.getStatisticCollector().getTimeStatisticsByStatusCodeRange().forEach((code, tc) -> tc.getTrackedTimes().forEach((name, tt) -> {
            if (tt.isEmpty()) {
                return;
            }
            StringBuilder sb = ctx.getNew();
            tt.forEach((le, count) -> {
                if (le.equals("SUM") || le.equals("COUNT")) {
                    return;
                }
                this.buildBucketLine(sb, proxy.getName(), (int)code, (String)le, (long)count, (String)name);
            });
            this.buildBucketLine(sb, proxy.getName(), (int)code, name + "_sum", (Long)tt.get("SUM"));
            this.buildBucketLine(sb, proxy.getName(), (int)code, name + "_count", (Long)tt.get("COUNT"));
        }));
    }

    private void buildStatuscodeLines(Context ctx, Proxy proxy) {
        proxy.getStatisticCollector().getStatisticsByStatusCodes().forEach((key, value) -> {
            this.buildLine(ctx.s1, proxy.getName(), value.getCount(), "code", (int)key, "count");
            this.buildLine(ctx.s2, proxy.getName(), value.getGoodCount(), "code", (int)key, "good_count");
            this.buildLine(ctx.s3, proxy.getName(), value.getGoodTotalTime(), "code", (int)key, "good_time");
            this.buildLine(ctx.s4, proxy.getName(), value.getGoodTotalBytesSent(), "code", (int)key, "good_bytes_req_body");
            this.buildLine(ctx.s5, proxy.getName(), value.getGoodTotalBytesReceived(), "code", (int)key, "good_bytes_res_body");
        });
    }

    private void buildLine(StringBuilder sb, String label, long value) {
        String prometheusName = this.prometheusCompatibleName("membrane_" + label);
        sb.append(prometheusName);
        sb.append(" ");
        sb.append(value);
        sb.append("\n");
    }

    private void buildBucketLine(StringBuilder sb, String ruleName, String label, long value) {
        String prometheusName = this.prometheusCompatibleName("membrane_" + label);
        sb.append(prometheusName);
        sb.append("{rule=\"");
        sb.append(this.prometheusCompatibleName(ruleName));
        sb.append("\"} ");
        sb.append(value);
        sb.append("\n");
    }

    private void buildBucketLine(StringBuilder sb, String ruleName, int code, String label, long value) {
        String prometheusName = this.prometheusCompatibleName("membrane_" + label);
        sb.append(prometheusName);
        sb.append("{rule=\"");
        sb.append(this.prometheusCompatibleName(ruleName));
        sb.append("\",code=\"");
        sb.append(code);
        sb.append("\"} ");
        sb.append(value);
        sb.append("\n");
    }

    private void buildBucketLine(StringBuilder sb, String ruleName, int code, String le, long valueCount, String infix) {
        String prometheusName = this.prometheusCompatibleName("membrane_" + infix + "_bucket");
        if (sb.isEmpty()) {
            sb.append("# TYPE ");
            sb.append(prometheusName);
            sb.append(" histogram\n");
        }
        sb.append(prometheusName);
        sb.append("{rule=\"");
        sb.append(this.prometheusCompatibleName(ruleName));
        sb.append("\",code=\"");
        sb.append(code);
        sb.append("\",le=\"");
        sb.append(le);
        sb.append("\"} ");
        sb.append(valueCount);
        sb.append("\n");
    }

    private void buildLine(StringBuilder sb, String ruleName, long value, String labelName, int labelValue, String postFix) {
        String prometheusName = this.prometheusCompatibleName("membrane_" + postFix);
        if (sb.isEmpty()) {
            sb.append("# TYPE ");
            sb.append(prometheusName);
            sb.append(" counter\n");
        }
        sb.append(prometheusName);
        sb.append("{rule=\"");
        sb.append(this.prometheusCompatibleName(ruleName));
        sb.append("\",");
        sb.append(this.prometheusCompatibleName(labelName));
        sb.append("=\"");
        sb.append(labelValue);
        sb.append("\"} ");
        sb.append(value);
        sb.append("\n");
    }

    private String prometheusCompatibleName(String name) {
        String result = this.names.get(name);
        if (result != null) {
            return result;
        }
        result = this.prettyPrint(name);
        result = this.ILLEGAL_CHARS.matcher(result).replaceAll("_");
        result = this.ILLEGAL_FIRST_CHAR.matcher(result).replaceAll("_");
        this.names.put(name, result);
        return result;
    }

    private String prettyPrint(String ruleName) {
        String[] split;
        StringBuilder sb = new StringBuilder();
        for (String s : split = ruleName.toLowerCase().split(" ")) {
            sb.append(s).append("_");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    @MCAttribute
    public void setBuckets(String buckets) {
        TimeCollector.setBuckets(Arrays.stream(buckets.replaceAll("\\s+", "").split(",")).map(Long::parseLong).collect(Collectors.toList()));
    }

    public String getBuckets() {
        return Utils.joinByComma(TimeCollector.getBuckets().stream().map(Object::toString).collect(Collectors.toList()));
    }

    @Override
    public String getShortDescription() {
        return "Returns Membrane's internal metrics in the Prometheus format.";
    }

    @Override
    public String getLongDescription() {
        return "Returns Membrane's internal metrics in the <a href=\"https://prometheus.io/docs/concepts/data_model/\">Prometheus</a> format.";
    }

    private static class Context {
        StringBuilder sb = new StringBuilder();
        List<StringBuilder> dynamic = new ArrayList<StringBuilder>();
        StringBuilder s1 = new StringBuilder();
        StringBuilder s2 = new StringBuilder();
        StringBuilder s3 = new StringBuilder();
        StringBuilder s4 = new StringBuilder();
        StringBuilder s5 = new StringBuilder();
        StringBuilder s6 = new StringBuilder();
        StringBuilder s7 = new StringBuilder();
        StringBuilder s8 = new StringBuilder();
        StringBuilder s9 = new StringBuilder();
        StringBuilder s10 = new StringBuilder();
        HashSet<String> seenRules = new HashSet();

        private Context() {
        }

        private StringBuilder getNew() {
            StringBuilder b = new StringBuilder();
            this.dynamic.add(b);
            return b;
        }

        private void reset() {
            this.s1.setLength(0);
            this.s2.setLength(0);
            this.s3.setLength(0);
            this.s4.setLength(0);
            this.s5.setLength(0);
            this.s6.setLength(0);
            this.s7.setLength(0);
            this.s8.setLength(0);
            this.s9.setLength(0);
            this.s10.setLength(0);
            this.dynamic.forEach(s -> s.setLength(0));
        }

        private void resetAll() {
            this.sb.setLength(0);
            this.seenRules.clear();
        }

        private void collect() {
            this.sb.append((CharSequence)this.s1);
            this.sb.append((CharSequence)this.s2);
            this.sb.append((CharSequence)this.s3);
            this.sb.append((CharSequence)this.s4);
            this.sb.append((CharSequence)this.s5);
            this.sb.append((CharSequence)this.s6);
            this.sb.append((CharSequence)this.s7);
            this.sb.append((CharSequence)this.s8);
            this.sb.append((CharSequence)this.s9);
            this.sb.append((CharSequence)this.s10);
            this.dynamic.forEach(s -> this.sb.append((CharSequence)s));
        }
    }
}

