/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.ratelimit;

import com.predic8.membrane.core.interceptor.ratelimit.RateLimitStrategy;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

public class LazyRateLimit
extends RateLimitStrategy {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private LocalDateTime nextCleanup = LocalDateTime.now();
    public final ConcurrentHashMap<String, AtomicInteger> requestCounterFromKey = new ConcurrentHashMap();

    public LazyRateLimit(Duration requestLimitDuration, int requestLimit) {
        this.requestLimitDuration = requestLimitDuration;
        this.requestLimit = requestLimit;
        this.incrementNextCleanupTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRequestLimitReached(String key) {
        Object object = this.lock;
        synchronized (object) {
            if (LocalDateTime.now().isAfter(this.nextCleanup)) {
                this.requestCounterFromKey.clear();
                this.incrementNextCleanupTime();
            }
        }
        this.addRequestEntry(key);
        return this.requestCounterFromKey.get(key).get() > this.requestLimit;
    }

    private void addRequestEntry(String addr) {
        this.requestCounterFromKey.computeIfAbsent(addr, s -> new AtomicInteger());
        this.requestCounterFromKey.get(addr).incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNextCleanupTime() {
        Object object = this.lock;
        synchronized (object) {
            this.nextCleanup = LocalDateTime.now().plus(this.requestLimitDuration);
        }
    }

    @Override
    public LocalDateTime getServiceAvailableAgainTime(String key) {
        return this.nextCleanup;
    }

    @Override
    public void updateAfterConfigChange() {
        this.requestCounterFromKey.clear();
        this.incrementNextCleanupTime();
    }
}

