/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.ratelimit;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.lang.AbstractExchangeExpressionInterceptor;
import com.predic8.membrane.core.interceptor.ratelimit.LazyRateLimit;
import com.predic8.membrane.core.interceptor.ratelimit.RateLimitStrategy;
import com.predic8.membrane.core.lang.ExchangeExpression;
import com.predic8.membrane.core.util.HttpUtil;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.spel.SpelEvaluationException;

@MCElement(name="rateLimiter")
public class RateLimitInterceptor
extends AbstractExchangeExpressionInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)RateLimitInterceptor.class.getName());
    public static final String X_RATELIMIT_DURATION = "X-RateLimit-Duration";
    public static final String X_RATELIMIT_LIMIT = "X-RateLimit-Limit";
    public static final String X_RATELIMIT_RESET = "X-RateLimit-Reset";
    private final RateLimitStrategy strategy;
    private List<String> trustedProxyList;
    private int trustedProxyCount = -1;
    private boolean trustForwardedFor;

    public RateLimitInterceptor() {
        this(Duration.ofHours(1L), 1000);
    }

    public RateLimitInterceptor(Duration requestLimitDuration, int requestLimit) {
        this.strategy = new LazyRateLimit(requestLimitDuration, requestLimit);
        this.name = "rate limiter";
        this.setFlow(Interceptor.Flow.Set.REQUEST_FLOW);
    }

    @Override
    protected ExchangeExpression getExchangeExpression() {
        if (this.expression.isEmpty()) {
            return null;
        }
        return ExchangeExpression.newInstance(this.router, this.language, this.expression);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        try {
            if (!this.strategy.isRequestLimitReached(this.getKey(exc))) {
                return Outcome.CONTINUE;
            }
        }
        catch (SpelEvaluationException e) {
            log.info("Cannot evaluate keyExpression {} cause is {}", (Object)this.expression, (Object)e.getCause());
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).addSubType("rate-limit").detail("Cannot evaluate keyExpression '%s' cause is %s".formatted(this.expression, e.getMessage())).buildAndSetResponse(exc);
            return Outcome.RETURN;
        }
        log.info("{} limit: {} duration: {} is exceeded. (clientIp: {})", new Object[]{this.getKey(exc), this.getRequestLimit(), this.getRequestLimitDuration(), exc.getRemoteAddrIp()});
        ProblemDetails.user(false, this.getDisplayName()).statusCode(429).title("Rate limit is exceeded.").addSubType("rate-limit").detail("The quota of the rate limit is exceeded. Try again in %s seconds.".formatted(this.strategy.getLimitReset(exc.getRemoteAddrIp()))).internal("limit", this.getRequestLimit()).internal("duration", this.getRequestLimitDuration()).buildAndSetResponse(exc);
        this.setHeaderRateLimitFieldsOnResponse(exc);
        return Outcome.RETURN;
    }

    private String getKey(Exchange exc) {
        String value;
        if (this.expression == null || this.expression.isEmpty()) {
            return this.getClientIp(exc);
        }
        try {
            value = this.exchangeExpression.evaluate(exc, Interceptor.Flow.REQUEST, String.class);
        }
        catch (Exception e) {
            log.info("Error evaluating expression {} for rate limit. Fallback to 'unknown'", (Object)this.expression);
            return "unknown";
        }
        if (!value.isEmpty()) {
            return value;
        }
        log.warn("The expression {} evaluates to null or there is an error in the expression. This may result in a wrong counting for the ratelimiter.", (Object)this.expression);
        return "unknown";
    }

    protected String getClientIp(Exchange exc) {
        String supposedClientId = this.computeClientIpFromForwards(exc);
        log.debug("Using client ip {}", (Object)supposedClientId);
        return supposedClientId;
    }

    private String computeClientIpFromForwards(Exchange exc) {
        if (!this.trustForwardedFor || exc.getRequest().getHeader().getXForwardedFor() == null) {
            return RateLimitInterceptor.useRemoteIpAddress(exc);
        }
        List<String> xForwardedFor = HttpUtil.getForwardedForList(exc);
        if (xForwardedFor.isEmpty()) {
            return RateLimitInterceptor.useRemoteIpAddress(exc);
        }
        log.debug("X-Forwared-For {}", xForwardedFor);
        if (this.trustedProxyList != null && !this.trustedProxyList.isEmpty()) {
            return this.getClientIPfromTrustedProxyList(exc, xForwardedFor);
        }
        if (this.trustedProxyCount != -1) {
            return this.getClientIPFromTrustedProxyCount(exc, xForwardedFor);
        }
        log.debug("No trustedProxyCount and no trustedProxyList.");
        if (xForwardedFor.size() != 1) {
            log.debug("More than 1 entry in X-Forwarded-For.");
            return exc.getRemoteAddrIp();
        }
        log.debug("Using entry in X-Forwarded-For");
        return xForwardedFor.getFirst();
    }

    private String getClientIPFromTrustedProxyCount(Exchange exc, List<String> xForwardedFor) {
        log.debug("Using trustedProxyCount of {}", (Object)this.trustedProxyCount);
        if (xForwardedFor.size() <= this.trustedProxyCount) {
            log.info("Forwarded-For entries {} do not match trusted proxies {}", xForwardedFor, this.trustedProxyList);
            return RateLimitInterceptor.useRemoteIpAddress(exc);
        }
        return RateLimitInterceptor.getOneBeforeTrustworthyProxy(xForwardedFor, this.trustedProxyCount);
    }

    private String getClientIPfromTrustedProxyList(Exchange exc, List<String> xForwardedFor) {
        log.debug("Checking list of trusted proxies");
        for (int i = 1; i <= this.trustedProxyList.size(); ++i) {
            String trustedProxy = this.trustedProxyList.get(this.trustedProxyList.size() - i);
            String forwardedFor = xForwardedFor.get(xForwardedFor.size() - i);
            log.debug("Checking proxy {} against {}", (Object)trustedProxy, (Object)forwardedFor);
            if (Objects.equals(trustedProxy, forwardedFor)) continue;
            log.info("Trusted proxy {} is not in X-Forwarded-For list {}, or not on the right position.", (Object)trustedProxy, xForwardedFor);
            return RateLimitInterceptor.useRemoteIpAddress(exc);
        }
        return RateLimitInterceptor.getOneBeforeTrustworthyProxy(xForwardedFor, this.trustedProxyList.size());
    }

    private static String useRemoteIpAddress(Exchange exc) {
        return exc.getRemoteAddrIp();
    }

    protected static String getOneBeforeTrustworthyProxy(List<String> l, int count) {
        return l.get(l.size() - count - 1).trim();
    }

    private void setHeaderRateLimitFieldsOnResponse(Exchange exc) {
        Header h = exc.getResponse().getHeader();
        h.add(X_RATELIMIT_DURATION, this.strategy.getLimitDurationPeriod());
        h.add(X_RATELIMIT_LIMIT, Integer.toString(this.strategy.requestLimit));
        h.add(X_RATELIMIT_RESET, this.strategy.getLimitReset(exc.getRemoteAddrIp()));
    }

    public int getRequestLimit() {
        return this.strategy.requestLimit;
    }

    @MCAttribute
    public void setRequestLimit(int limit) {
        this.strategy.setRequestLimit(limit);
    }

    public String getRequestLimitDuration() {
        return this.strategy.requestLimitDuration.toString();
    }

    @MCAttribute
    public void setRequestLimitDuration(String duration) {
        this.setRequestLimitDuration(Duration.parse(duration));
    }

    public void setRequestLimitDuration(Duration duration) {
        this.strategy.setRequestLimitDuration(duration);
    }

    @MCAttribute
    public void setKeyExpression(String expression) {
        this.expression = expression;
    }

    public String getKeyExpression() {
        return this.expression;
    }

    public String getTrustedProxyList() {
        return this.trustedProxyList == null ? null : String.join((CharSequence)",", this.trustedProxyList);
    }

    @MCAttribute
    public void setTrustedProxyList(String trustedProxyList) {
        this.trustedProxyList = Arrays.stream(trustedProxyList.split(",")).map(String::trim).toList();
    }

    public int getTrustedProxyCount() {
        return this.trustedProxyCount;
    }

    @MCAttribute
    public void setTrustedProxyCount(int trustedProxyCount) {
        this.trustedProxyCount = trustedProxyCount;
    }

    public boolean isTrustForwardedFor() {
        return this.trustForwardedFor;
    }

    @MCAttribute
    public void setTrustForwardedFor(boolean trustForwardedFor) {
        this.trustForwardedFor = trustForwardedFor;
    }

    @Override
    public String getShortDescription() {
        return "Limits incoming requests to %s requests every %s.".formatted(this.strategy.getRequestLimit(), this.strategy.getRequestLimitDuration());
    }
}

