/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.ratelimit;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public abstract class RateLimitStrategy {
    protected Duration requestLimitDuration;
    protected int requestLimit;

    public Duration getRequestLimitDuration() {
        return this.requestLimitDuration;
    }

    public void setRequestLimitDuration(Duration requestLimitDuration) {
        this.requestLimitDuration = requestLimitDuration;
        this.updateAfterConfigChange();
    }

    public int getRequestLimit() {
        return this.requestLimit;
    }

    public void setRequestLimit(int requestLimit) {
        this.requestLimit = requestLimit;
        this.updateAfterConfigChange();
    }

    public String getLimitDurationPeriod() {
        return this.requestLimitDuration.toString();
    }

    public String getLimitReset(String key) {
        return Long.toString(this.getServiceAvailableAgainTime(key).toEpochSecond(ZoneOffset.UTC) - LocalDateTime.now().toEpochSecond(ZoneOffset.UTC));
    }

    public abstract boolean isRequestLimitReached(String var1);

    public abstract LocalDateTime getServiceAvailableAgainTime(String var1);

    public abstract void updateAfterConfigChange();
}

