/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.registration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.JdbcUserDataProvider;
import com.predic8.membrane.core.interceptor.registration.ErrorMessages;
import com.predic8.membrane.core.interceptor.registration.SecurityUtils;
import com.predic8.membrane.core.interceptor.registration.entity.User;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="accountRegistration")
public class RegistrationInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RegistrationInterceptor.class);
    private JdbcUserDataProvider userDataProvider;

    @Override
    public void init() {
        super.init();
        this.userDataProvider = (JdbcUserDataProvider)this.router.getBeanFactory().getBean(JdbcUserDataProvider.class);
        this.userDataProvider.init(this.router);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Outcome handleRequest(Exchange exc) {
        User user;
        Request request = exc.getRequest();
        if (!request.isPOSTRequest()) {
            return ErrorMessages.returnErrorBadRequest(exc);
        }
        try {
            user = (User)new ObjectMapper().readValue(request.getBodyAsStringDecoded(), User.class);
        }
        catch (IOException e) {
            return ErrorMessages.returnErrorBadRequest(exc);
        }
        try (Connection connection = this.userDataProvider.getDatasource().getConnection();){
            try (ResultSet rs = connection.createStatement().executeQuery(this.getIsAccountNameAvailableSQL(user));){
                if (rs.next() && rs.getInt(1) != 0) {
                    Outcome outcome = ErrorMessages.returnErrorUserAlreadyExists(exc);
                    return outcome;
                }
            }
            if (!SecurityUtils.isHashedPassword(user.getPassword())) {
                user.setPassword(SecurityUtils.createPasswdCompatibleHash(user.getPassword()));
            }
            connection.createStatement().executeUpdate(this.getInsertAccountIntoDatabaseSQL(user));
        }
        catch (SQLException e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Could not access database").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        exc.setResponse(Response.ok().build());
        return Outcome.RETURN;
    }

    private String getInsertAccountIntoDatabaseSQL(User user) {
        return String.format("INSERT INTO %s", this.userDataProvider.getTableName()) + " (" + this.userDataProvider.getUserColumnName() + ", " + this.userDataProvider.getPasswordColumnName() + ") VALUES('" + user.getEmail() + "', '" + user.getPassword() + "')";
    }

    private String getIsAccountNameAvailableSQL(User user) {
        return "SELECT COUNT(*) FROM " + this.userDataProvider.getTableName() + " WHERE " + this.userDataProvider.getUserColumnName() + " = '" + user.getEmail() + "'";
    }
}

