/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.registration;

import com.google.common.io.BaseEncoding;
import java.security.SecureRandom;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.Crypt;

public class SecurityUtils {
    private static final SecureRandom secureRandom = new SecureRandom();

    public static boolean isHashedPassword(String postDataPassword) {
        String[] split = postDataPassword.split(Pattern.quote("$"));
        return split.length == 4 && split[0].isEmpty() && split[3].length() >= 20;
    }

    static String createPasswdCompatibleHash(String password) {
        byte[] salt = new byte[128];
        secureRandom.nextBytes(salt);
        String saltString = BaseEncoding.base64().encode(salt);
        if (saltString.length() > 16) {
            saltString = saltString.substring(0, 16);
        }
        return SecurityUtils.createPasswdCompatibleHash(password, saltString);
    }

    public static String extractSalt(String password) {
        return password.split(Pattern.quote("$"))[2];
    }

    public static String createPasswdCompatibleHash(String algo, String password, String salt) {
        return Crypt.crypt((String)password, (String)("$" + algo + "$" + salt));
    }

    public static String createPasswdCompatibleHash(String password, String saltString) {
        return SecurityUtils.createPasswdCompatibleHash("6", password, saltString);
    }

    public static String extractMagicString(String password) {
        return password.split(Pattern.quote("$"))[1];
    }
}

