/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.rest;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.xml.Request;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="http2xml")
public class HTTP2XMLInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)HTTP2XMLInterceptor.class.getName());

    public HTTP2XMLInterceptor() {
        this.name = "http 2 xml";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        try {
            return this.handleRequestInternal(exc);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.user(this.router.isProduction(), this.getDisplayName()).detail("Could not generate XML from HTTP information!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    public Outcome handleRequestInternal(Exchange exc) throws Exception {
        log.debug("uri: {}", (Object)exc.getRequest().getUri());
        String res = new Request(exc.getRequest()).toXml();
        log.debug("http-xml: {}", (Object)res);
        exc.getRequest().setBodyContent(res.getBytes(StandardCharsets.UTF_8));
        exc.getRequest().setMethod("POST");
        exc.getRequest().getHeader().setSOAPAction("");
        return Outcome.CONTINUE;
    }
}

