/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.rest;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.MimeType;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.rest.SOAPRESTHelper;
import com.predic8.membrane.core.interceptor.rest.XML2HTTP;
import com.predic8.membrane.core.proxies.AbstractServiceProxy;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.SSLableProxy;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

@MCElement(name="rest2Soap")
public class REST2SOAPInterceptor
extends SOAPRESTHelper {
    private static final Logger log = LoggerFactory.getLogger((String)REST2SOAPInterceptor.class.getName());
    private List<Mapping> mappings = new ArrayList<Mapping>();
    private Boolean isSOAP12;

    public REST2SOAPInterceptor() {
        this.name = "rest 2 soap gateway";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        log.debug("uri: {}", (Object)this.getURI(exc));
        String uri = this.getURI(exc);
        Mapping mapping = this.findFirstMatchingRegEx(uri);
        if (mapping == null) {
            return Outcome.CONTINUE;
        }
        try {
            this.transformAndReplaceBody(exc.getRequest(), mapping.requestXSLT, this.getRequestXMLSource(exc), exc.getStringProperties());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.user(this.router.isProduction(), this.getDisplayName()).detail("Could not covert REST to SOAP!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        this.modifyRequest(exc, mapping);
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        try {
            return this.handleResponseInternal(exc);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.user(this.router.isProduction(), this.getDisplayName()).detail("Could not covert SOAP to REST!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    public Outcome handleResponseInternal(Exchange exc) throws Exception {
        Mapping mapping = this.getRESTURL(exc);
        log.debug("restURL: {}", (Object)mapping);
        if (this.getRESTURL(exc) == null) {
            return Outcome.CONTINUE;
        }
        if (log.isDebugEnabled()) {
            log.debug("response: {}", (Object)new String(this.getTransformer(null).transform(this.getBodySource(exc), exc.getStringProperties()), StandardCharsets.UTF_8));
        }
        exc.getResponse().setBodyContent(this.getTransformer(mapping.responseXSLT).transform(this.getBodySource(exc)));
        Header header = exc.getResponse().getHeader();
        header.removeFields("Content-Type");
        header.setContentType("text/xml;charset=UTF-8");
        XML2HTTP.unwrapMessageIfNecessary(exc.getResponse());
        this.convertResponseToJSONIfNecessary(exc.getRequest().getHeader(), exc.getResponse(), exc.getStringProperties());
        return Outcome.CONTINUE;
    }

    private void convertResponseToJSONIfNecessary(Header header, Response response, Map<String, String> properties) throws Exception {
        if (!response.isXML()) {
            return;
        }
        String accept = header.getFirstValue("Accept");
        if (accept == null) {
            return;
        }
        List<MediaType> types = MimeType.sortMimeTypeByQualityFactorAscending(accept);
        if (types.isEmpty()) {
            return;
        }
        if (!MimeType.isJson(types.getFirst().toString())) {
            return;
        }
        response.setBodyContent(this.xml2json(response.getBodyAsStreamDecoded(), properties));
        this.setJSONContentType(response.getHeader());
    }

    private byte[] xml2json(InputStream xmlResp, Map<String, String> properties) throws Exception {
        return this.getTransformer("classpath:/com/predic8/membrane/core/interceptor/rest/xml2json.xsl").transform(new StreamSource(xmlResp), properties);
    }

    private StreamSource getBodySource(Exchange exc) {
        return new StreamSource(exc.getResponse().getBodyAsStreamDecoded());
    }

    private Mapping getRESTURL(Exchange exc) {
        return (Mapping)exc.getProperty("mapping");
    }

    private Mapping findFirstMatchingRegEx(String uri) {
        for (Mapping m : this.mappings) {
            if (!Pattern.matches(m.regex, uri)) continue;
            return m;
        }
        return null;
    }

    private void modifyRequest(AbstractExchange exc, Mapping mapping) {
        exc.getRequest().setMethod("POST");
        exc.getRequest().getHeader().setSOAPAction(mapping.soapAction);
        Header header = exc.getRequest().getHeader();
        header.removeFields("Content-Type");
        header.setContentType(this.isSOAP12(exc) ? "application/soap+xml" : "text/xml;charset=UTF-8");
        exc.setProperty("mapping", mapping);
        this.setServiceEndpoint(exc, mapping);
    }

    private boolean isSOAP12(AbstractExchange exc) {
        if (this.isSOAP12 != null) {
            return this.isSOAP12;
        }
        this.isSOAP12 = "http://www.w3.org/2003/05/soap-envelope".equals(this.getRootElementNamespace(exc.getRequest().getBodyAsStream()));
        return this.isSOAP12;
    }

    private String getRootElementNamespace(InputStream stream) {
        try {
            XMLEventReader xer = XMLInputFactory.newFactory().createXMLEventReader(stream);
            while (xer.hasNext()) {
                XMLEvent event = xer.nextEvent();
                if (!event.isStartElement()) continue;
                return event.asStartElement().getName().getNamespaceURI();
            }
        }
        catch (XMLStreamException e) {
            log.error("Could not determine root element namespace for check whether namespace is SOAP 1.2.", (Throwable)e);
        }
        return null;
    }

    private void setJSONContentType(Header header) {
        header.removeFields("Content-Type");
        header.setContentType("application/json;charset=utf-8");
    }

    private void setServiceEndpoint(AbstractExchange exc, Mapping mapping) {
        exc.getRequest().setUri(this.getURI(exc).replaceAll(mapping.regex, mapping.soapURI));
        String newDestination = this.getNewDestination(exc);
        exc.getDestinations().clear();
        exc.getDestinations().add(newDestination);
        log.debug("destination set to: {}", (Object)newDestination);
    }

    private String getNewDestination(AbstractExchange exc) {
        return this.getProtocol(exc) + "://" + ((AbstractServiceProxy)exc.getProxy()).getTargetHost() + ":" + ((AbstractServiceProxy)exc.getProxy()).getTargetPort() + exc.getRequest().getUri();
    }

    private String getProtocol(AbstractExchange exc) {
        SSLableProxy sp;
        Proxy proxy = exc.getProxy();
        if (proxy instanceof SSLableProxy && (sp = (SSLableProxy)proxy).getSslOutboundContext() != null) {
            return "https";
        }
        return "http";
    }

    private String getURI(AbstractExchange exc) {
        return exc.getRequest().getUri();
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    @MCChildElement
    public void setMappings(List<Mapping> mappings) {
        this.mappings = mappings;
    }

    @Override
    public String getShortDescription() {
        return "Transforms REST requests into SOAP and responses vice versa.";
    }

    @MCElement(name="mapping", topLevel=false, id="rest2Soap-mapping")
    public static class Mapping
    extends AbstractXmlElement {
        public String regex;
        public String soapAction;
        public String soapURI;
        public String requestXSLT;
        public String responseXSLT;

        @Override
        protected void parseAttributes(XMLStreamReader token) {
            this.regex = token.getAttributeValue("", "regex");
            this.soapAction = token.getAttributeValue("", "soapAction");
            this.soapURI = token.getAttributeValue("", "soapURI");
            this.requestXSLT = token.getAttributeValue("", "requestXSLT");
            this.responseXSLT = token.getAttributeValue("", "responseXSLT");
        }

        @Override
        public void write(XMLStreamWriter out) throws XMLStreamException {
            out.writeStartElement("mapping");
            out.writeAttribute("regex", this.regex);
            out.writeAttribute("soapAction", this.soapAction);
            out.writeAttribute("soapURI", this.soapURI);
            out.writeAttribute("requestXSLT", this.requestXSLT);
            out.writeAttribute("responseXSLT", this.responseXSLT);
            out.writeEndElement();
        }

        public String getRegex() {
            return this.regex;
        }

        @MCAttribute
        @Required
        public void setRegex(String regex) {
            this.regex = regex;
        }

        public String getSoapAction() {
            return this.soapAction;
        }

        @MCAttribute
        @Required
        public void setSoapAction(String soapAction) {
            this.soapAction = soapAction;
        }

        public String getSoapURI() {
            return this.soapURI;
        }

        @MCAttribute
        @Required
        public void setSoapURI(String soapURI) {
            this.soapURI = soapURI;
        }

        public String getRequestXSLT() {
            return this.requestXSLT;
        }

        @MCAttribute
        @Required
        public void setRequestXSLT(String requestXSLT) {
            this.requestXSLT = requestXSLT;
        }

        public String getResponseXSLT() {
            return this.responseXSLT;
        }

        @MCAttribute
        @Required
        public void setResponseXSLT(String responseXSLT) {
            this.responseXSLT = responseXSLT;
        }
    }
}

