/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.rest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.administration.Mapping;
import com.predic8.membrane.core.interceptor.rest.JSONContent;
import com.predic8.membrane.core.interceptor.rest.QueryParameter;
import com.predic8.membrane.core.util.URLParamUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RESTInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)RESTInterceptor.class.getName());
    private boolean readOnly;
    private final JsonFactory jsonFactory = new JsonFactory();

    @Override
    public Outcome handleRequest(Exchange exc) {
        Outcome o;
        log.debug("request: {}", (Object)exc.getOriginalRequestUri());
        exc.setTimeReqSent(System.currentTimeMillis());
        try {
            o = this.dispatchRequest(exc);
        }
        catch (Exception e) {
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Error dispatching request!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        exc.setReceived();
        exc.setTimeResReceived(System.currentTimeMillis());
        return o;
    }

    protected Response json(JSONContent content) throws Exception {
        StringWriter jsonTxt = new StringWriter();
        JsonGenerator gen = this.jsonFactory.createGenerator((Writer)jsonTxt);
        content.write(gen);
        gen.flush();
        return Response.ok().header("Content-Type", "application/json;charset=utf-8").body(jsonTxt.toString()).build();
    }

    private Outcome dispatchRequest(Exchange exc) throws Exception {
        String path = this.router.getUriFactory().create(exc.getDestinations().getFirst()).getPath();
        for (Method m : this.getClass().getMethods()) {
            Matcher matcher;
            Mapping a = m.getAnnotation(Mapping.class);
            if (a == null || !(matcher = Pattern.compile(a.value()).matcher(path)).matches()) continue;
            exc.setResponse((Response)m.invoke((Object)this, this.getParameters(exc, path, m, matcher)));
            return Outcome.RETURN;
        }
        return Outcome.CONTINUE;
    }

    private Object[] getParameters(Exchange exc, String path, Method m, Matcher matcher) throws Exception {
        Object[] objectArray;
        switch (m.getParameterTypes().length) {
            case 2: {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.getQueryParameter(exc, matcher);
                objectArray = objectArray2;
                objectArray2[1] = RESTInterceptor.getRelativeRootPath(path);
                break;
            }
            case 3: {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = this.getQueryParameter(exc, matcher);
                objectArray3[1] = RESTInterceptor.getRelativeRootPath(path);
                objectArray = objectArray3;
                objectArray3[2] = exc;
                break;
            }
            default: {
                throw new InvalidParameterException("@Mapping is supposed to annotate a 2-parameter method.");
            }
        }
        return objectArray;
    }

    private QueryParameter getQueryParameter(Exchange exc, Matcher matcher) throws Exception {
        return new QueryParameter(URLParamUtil.getParams(this.router.getUriFactory(), exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR), matcher);
    }

    public static String getRelativeRootPath(String path) {
        int depth = 0;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '/') continue;
            ++depth;
        }
        if (depth > 0) {
            --depth;
        }
        StringBuilder relativeRootPath = new StringBuilder();
        if (depth == 0) {
            relativeRootPath.append(".");
        } else {
            while (depth > 0) {
                if (depth == 1) {
                    relativeRootPath.append("..");
                } else {
                    relativeRootPath.append("../");
                }
                --depth;
            }
        }
        return relativeRootPath.toString();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

