/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.rewrite;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.URLUtil;
import com.predic8.membrane.core.ws.relocator.Relocator;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="reverseProxying")
public class ReverseProxyingInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ReverseProxyingInterceptor.class);

    public ReverseProxyingInterceptor() {
        this.name = "reverse proxy";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        URL target;
        if (exc.getRequest() == null) {
            return Outcome.CONTINUE;
        }
        String destination = exc.getRequest().getHeader().getFirstValue("Destination");
        if (destination == null) {
            return Outcome.CONTINUE;
        }
        if (!destination.contains("://")) {
            return Outcome.CONTINUE;
        }
        if (!this.isSameSchemeHostAndPort(this.getProtocol(exc) + "://" + exc.getRequest().getHeader().getHost(), destination)) {
            return Outcome.CONTINUE;
        }
        if (exc.getDestinations().isEmpty()) {
            try {
                exc.getRequest().getHeader().setValue("Destination", new URL(destination).getFile());
            }
            catch (MalformedURLException e) {
                log.error("Invalid destination URL: {}", (Object)destination, (Object)e);
            }
            return Outcome.CONTINUE;
        }
        try {
            target = new URL(exc.getDestinations().getFirst());
        }
        catch (MalformedURLException e) {
            log.error("Could not parse target URL: {}", (Object)destination);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Could not parse target URL").internal("URL", exc.getDestinations().getFirst()).exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        exc.getRequest().getHeader().setValue("Destination", Relocator.getNewLocation(destination, target.getProtocol(), target.getHost(), URLUtil.getPortFromURL(target), exc.getHandler().getContextPath(exc)));
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        if (exc.getResponse() == null) {
            return Outcome.CONTINUE;
        }
        String location = exc.getResponse().getHeader().getFirstValue("Location");
        if (location == null) {
            return Outcome.CONTINUE;
        }
        if (!location.contains("://")) {
            return Outcome.CONTINUE;
        }
        if (!this.isSameSchemeHostAndPort(location, exc.getDestinations().getFirst())) {
            return Outcome.CONTINUE;
        }
        if (exc.getOriginalHostHeaderHost() == null) {
            try {
                exc.getResponse().getHeader().setValue("Location", new URL(location).getFile());
            }
            catch (MalformedURLException e) {
                log.error("Could not parse URL for Location header: {}", (Object)location, (Object)e);
            }
            return Outcome.CONTINUE;
        }
        exc.getResponse().getHeader().setValue("Location", Relocator.getNewLocation(location, this.getProtocol(exc), exc.getOriginalHostHeaderHost(), this.getPort(exc), exc.getHandler().getContextPath(exc)));
        return Outcome.CONTINUE;
    }

    private boolean isSameSchemeHostAndPort(String location1, String location2) {
        try {
            if (location1.startsWith("/") || location2.startsWith("/")) {
                return false;
            }
            URL loc2 = new URL(location2);
            URL loc1 = new URL(location1);
            if (loc2.getProtocol() != null && !loc2.getProtocol().equals(loc1.getProtocol())) {
                return false;
            }
            if (loc2.getHost() != null && !loc2.getHost().equals(loc1.getHost())) {
                return false;
            }
            return URLUtil.getPortFromURL(loc2) == URLUtil.getPortFromURL(loc1);
        }
        catch (MalformedURLException e) {
            if (e.getMessage().startsWith("unknown protocol:")) {
                return false;
            }
            log.warn("Location 1: {} Location 2: {}", new Object[]{location1, location2, e});
            return false;
        }
    }

    int getPort(Exchange exc) {
        return exc.getHandler().getLocalPort();
    }

    private String getProtocol(Exchange exc) {
        return exc.getProxy().getProtocol();
    }
}

