/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.rewrite;

import com.googlecode.jatl.Html;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.TextUtil;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLUtil;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="rewriter")
public class RewriteInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)RewriteInterceptor.class.getName());
    private List<Mapping> mappings = new ArrayList<Mapping>();

    public RewriteInterceptor() {
        this.name = "url rewriter";
        this.setFlow(Interceptor.Flow.Set.REQUEST_FLOW);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        this.logMappings();
        ListIterator<String> it = exc.getDestinations().listIterator();
        while (it.hasNext()) {
            String dest = it.next();
            String pathQuery = this.getPathQueryOrSetError(this.router.getUriFactory(), dest, exc);
            if (pathQuery == null) {
                return Outcome.RETURN;
            }
            int pathBegin = -1;
            int authorityBegin = dest.indexOf("//");
            if (authorityBegin != -1) {
                pathBegin = dest.indexOf("/", authorityBegin + 2);
            }
            String schemaHostPort = pathBegin == -1 ? null : dest.substring(0, pathBegin);
            log.debug("pathQuery: {}", (Object)pathQuery);
            log.debug("schemaHostPort: {}", (Object)schemaHostPort);
            Mapping mapping = this.findFirstMatchingRegEx(pathQuery);
            if (mapping == null) continue;
            Type do_ = mapping.getDo();
            log.debug("match found: {} replacing with: {} for type: {}", new Object[]{mapping.from, mapping.to, do_});
            Object newDest = this.replace(pathQuery, mapping);
            if (do_ == Type.REDIRECT_PERMANENT || do_ == Type.REDIRECT_TEMPORARY) {
                exc.setResponse(Response.redirect((String)newDest, do_ == Type.REDIRECT_PERMANENT).build());
                return Outcome.RETURN;
            }
            if (!((String)newDest).contains("://") && schemaHostPort != null) {
                newDest = schemaHostPort + (String)newDest;
            }
            it.set((String)newDest);
        }
        Mapping mapping = this.findFirstMatchingRegEx(exc.getRequest().getUri());
        if (mapping != null && mapping.do_ == Type.REWRITE) {
            String newDest = this.replace(exc.getRequest().getUri(), mapping);
            if (newDest.contains("://") && (newDest = this.getPathQueryOrSetError(this.router.getUriFactory(), newDest, exc)) == null) {
                return Outcome.RETURN;
            }
            exc.getRequest().setUri(newDest);
        }
        return Outcome.CONTINUE;
    }

    private String getPathQueryOrSetError(URIFactory factory, String destination, Exchange exc) {
        try {
            return URLUtil.getPathQuery(factory, destination);
        }
        catch (URISyntaxException ignore) {
            log.info("Can't parse query: {}", (Object)destination);
            ProblemDetails.user(false, this.getDisplayName()).addSubType("path").title("The path does not follow the URI specification. Confirm the validity of the provided URL.").detail("Check the URL: " + destination).internal("component", "rewrite").internal("path", destination).buildAndSetResponse(exc);
            return null;
        }
    }

    private void logMappings() {
        for (Mapping m : this.mappings) {
            log.debug("[from: {}],[to: {}],[do: {}]", new Object[]{m.from, m.to, m.do_});
        }
    }

    private String replace(String uri, Mapping mapping) {
        String replaced = uri.replaceAll(mapping.from, mapping.to);
        log.debug("replaced URI: {}", (Object)replaced);
        return replaced;
    }

    private Mapping findFirstMatchingRegEx(String uri) {
        for (Mapping m : this.mappings) {
            if (!m.matches(uri)) continue;
            return m;
        }
        return null;
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    @MCChildElement
    @Required
    public void setMappings(List<Mapping> mappings) {
        this.mappings = mappings;
    }

    @Override
    public String getShortDescription() {
        EnumSet<Type> s = EnumSet.noneOf(Type.class);
        for (Mapping m : this.mappings) {
            s.add(m.getDo());
        }
        return String.valueOf(TextUtil.capitalize(TextUtil.toEnglishList("or", s.contains((Object)Type.REDIRECT_PERMANENT) || s.contains((Object)Type.REDIRECT_TEMPORARY) ? TextUtil.toEnglishList("or", s.contains((Object)Type.REDIRECT_PERMANENT) ? "permanently" : null, s.contains((Object)Type.REDIRECT_TEMPORARY) ? "temporarily" : null) + " redirects" : null, s.contains((Object)Type.REWRITE) ? "rewrites" : null))) + " URLs.";
    }

    @Override
    public String getLongDescription() {
        StringWriter sw = new StringWriter();
        new Html(sw){
            {
                this.text(RewriteInterceptor.this.getShortDescription());
                ((Html)this.table()).style("margin-top: 5pt;");
                this.thead();
                this.tr();
                ((Html)((Html)this.th()).text("From")).end();
                ((Html)((Html)this.th()).text("To")).end();
                ((Html)((Html)this.th()).text("Action")).end();
                this.end();
                this.end();
                this.tbody();
                for (Mapping m : RewriteInterceptor.this.mappings) {
                    this.tr();
                    ((Html)((Html)this.td()).text(m.from)).end();
                    ((Html)((Html)this.td()).text(m.to)).end();
                    ((Html)((Html)this.td()).text(m.do_.toString())).end();
                    this.end();
                }
                this.end();
                this.end();
            }
        };
        return sw.toString();
    }

    @MCElement(name="map", topLevel=false, id="rewriter-map")
    public static class Mapping {
        public String to;
        public String from;
        private Type do_;
        private Pattern pattern;

        public Mapping() {
        }

        public Mapping(String from, String to, String do_) {
            this.from = from;
            this.to = to;
            if (StringUtils.isEmpty((CharSequence)do_)) {
                this.do_ = this.getDo();
            } else if (do_.equals("rewrite")) {
                this.do_ = Type.REWRITE;
            } else if (do_.equals("redirect") || do_.equals("redirect-temporary")) {
                this.do_ = Type.REDIRECT_TEMPORARY;
            } else if (do_.equals("redirect-permanent")) {
                this.do_ = Type.REDIRECT_PERMANENT;
            } else {
                throw new IllegalArgumentException("Unknown value '" + do_ + "' for rewriter/@do.");
            }
            this.pattern = Pattern.compile(from);
        }

        public boolean matches(String uri) {
            return this.pattern.matcher(uri).find();
        }

        public String getFrom() {
            return this.from;
        }

        @MCAttribute
        @Required
        public void setFrom(String from) {
            this.from = from;
            this.pattern = from == null ? null : Pattern.compile(from);
        }

        public String getTo() {
            return this.to;
        }

        @MCAttribute
        @Required
        public void setTo(String to) {
            this.to = to;
        }

        public Type getDo() {
            if (this.do_ == null) {
                this.do_ = this.to.contains("://") ? Type.REDIRECT_TEMPORARY : Type.REWRITE;
            }
            return this.do_;
        }

        @MCAttribute
        public void setDo(Type do_) {
            this.do_ = do_;
        }
    }

    public static enum Type {
        REWRITE,
        REDIRECT_TEMPORARY,
        REDIRECT_PERMANENT;

    }
}

