/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.schemavalidation;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.schemavalidation.AbstractMessageValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.SchemaValidatorErrorHandler;
import com.predic8.membrane.core.interceptor.schemavalidation.ValidatorInterceptor;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.schema.Schema;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractXMLSchemaValidator
extends AbstractMessageValidator {
    private static final Logger log = LoggerFactory.getLogger((String)AbstractXMLSchemaValidator.class.getName());
    private ArrayBlockingQueue<List<Validator>> validators;
    protected final XOPReconstitutor xopr;
    protected final String location;
    protected final ResolverMap resolver;
    protected final ValidatorInterceptor.FailureHandler failureHandler;
    private final boolean skipFaults;
    protected final AtomicLong valid = new AtomicLong();
    protected final AtomicLong invalid = new AtomicLong();

    public AbstractXMLSchemaValidator(ResolverMap resolver, String location, ValidatorInterceptor.FailureHandler failureHandler) {
        this(resolver, location, failureHandler, false);
    }

    public AbstractXMLSchemaValidator(ResolverMap resolver, String location, ValidatorInterceptor.FailureHandler failureHandler, boolean skipFaults) {
        this.location = location;
        this.resolver = resolver;
        this.failureHandler = failureHandler;
        this.skipFaults = skipFaults;
        this.xopr = new XOPReconstitutor();
    }

    @Override
    public void init() {
        super.init();
        int concurrency = Runtime.getRuntime().availableProcessors() * 2;
        this.validators = new ArrayBlockingQueue(concurrency);
        for (int i = 0; i < concurrency; ++i) {
            this.validators.add(this.createValidators());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Outcome validateMessage(Exchange exc, Interceptor.Flow flow) throws Exception {
        Message msg = exc.getMessage(flow);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        String preliminaryError = this.getPreliminaryError(this.xopr, msg);
        if (preliminaryError == null) {
            List<Validator> vals = this.validators.take();
            try {
                for (Validator validator : vals) {
                    SchemaValidatorErrorHandler handler = (SchemaValidatorErrorHandler)validator.getErrorHandler();
                    try {
                        validator.validate(this.getMessageBody(this.xopr.reconstituteIfNecessary(msg)));
                        if (handler.noErrors()) {
                            this.valid.incrementAndGet();
                            Outcome outcome = Outcome.CONTINUE;
                            return outcome;
                        }
                        exceptions.add(handler.getException());
                    }
                    finally {
                        handler.reset();
                    }
                }
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            finally {
                this.validators.put(vals);
            }
        } else {
            exceptions.add(new Exception(preliminaryError));
        }
        if (this.skipFaults && this.isFault(msg)) {
            this.valid.incrementAndGet();
            return Outcome.CONTINUE;
        }
        String errorMsg = this.getErrorMsg(exceptions);
        if (this.failureHandler != null) {
            this.failureHandler.handleFailure(errorMsg, exc);
        }
        exc.setProperty("error", errorMsg);
        this.setErrorResponse(exc, flow, exceptions);
        msg.getHeader().add("X-Validation-Error-Source", flow.name());
        this.invalid.incrementAndGet();
        return Outcome.ABORT;
    }

    protected List<Validator> createValidators() {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setResourceResolver(this.resolver.toLSResourceResolver());
        ArrayList<Validator> validators = new ArrayList<Validator>();
        for (Schema schema : this.getSchemas()) {
            log.debug("Creating validator for schema: {}", (Object)schema);
            validators.add(this.getValidator(schema, sf));
        }
        return validators;
    }

    @NotNull
    private Validator getValidator(Schema schema, SchemaFactory sf) {
        try {
            Validator validator = sf.newSchema(this.getStreamSource(schema)).newValidator();
            validator.setResourceResolver(this.resolver.toLSResourceResolver());
            validator.setErrorHandler(new SchemaValidatorErrorHandler());
            return validator;
        }
        catch (SAXException e) {
            throw new ConfigurationException("Cannot read schema %s.".formatted(schema.getName()), e);
        }
    }

    @NotNull
    private StreamSource getStreamSource(Schema schema) {
        StreamSource ss = new StreamSource(new StringReader(schema.getAsString()));
        ss.setSystemId(this.location);
        return ss;
    }

    private String getErrorMsg(List<Exception> excs) {
        StringBuilder buf = new StringBuilder();
        buf.append("%s: ".formatted(this.getErrorTitle()));
        for (Exception e : excs) {
            buf.append(e);
            buf.append("; ");
        }
        return buf.toString();
    }

    protected List<Map<String, Object>> convertExceptionsToMap(List<Exception> exceptions) {
        return exceptions.stream().map(AbstractXMLSchemaValidator::createErrorEntry).toList();
    }

    @NotNull
    private static Map<String, Object> createErrorEntry(Exception e) {
        LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>();
        error.put("message", e.getMessage());
        if (e instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)e;
            error.put("line", spe.getLineNumber());
            error.put("column", spe.getColumnNumber());
        }
        return error;
    }

    @Override
    public long getValid() {
        return this.valid.get();
    }

    @Override
    public long getInvalid() {
        return this.invalid.get();
    }

    protected abstract List<Schema> getSchemas();

    protected abstract Source getMessageBody(InputStream var1);

    protected abstract void setErrorResponse(Exchange var1, String var2);

    protected abstract void setErrorResponse(Exchange var1, Interceptor.Flow var2, List<Exception> var3);

    protected abstract boolean isFault(Message var1);

    protected abstract String getPreliminaryError(XOPReconstitutor var1, Message var2);

    @Override
    public String getErrorTitle() {
        return "XML message validation failed";
    }
}

