/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.schemavalidation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.schemavalidation.AbstractMessageValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.ValidatorInterceptor;
import com.predic8.membrane.core.resolver.Resolver;
import com.predic8.membrane.core.util.ConfigurationException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONSchemaValidator
extends AbstractMessageValidator {
    private static final Logger log = LoggerFactory.getLogger(JSONSchemaValidator.class);
    private static final ObjectMapper om = new ObjectMapper();
    private JsonSchema schema;
    private final Resolver resolver;
    private final String jsonSchema;
    private final ValidatorInterceptor.FailureHandler failureHandler;
    private final AtomicLong valid = new AtomicLong();
    private final AtomicLong invalid = new AtomicLong();

    public JSONSchemaValidator(Resolver resolver, String jsonSchema, ValidatorInterceptor.FailureHandler failureHandler) {
        this.resolver = resolver;
        this.jsonSchema = jsonSchema;
        this.failureHandler = failureHandler;
    }

    @Override
    public String getName() {
        return "JSON Schema Validator";
    }

    @Override
    public void init() {
        super.init();
        this.createValidators();
    }

    @Override
    public Outcome validateMessage(Exchange exc, Interceptor.Flow flow) throws Exception {
        return this.validateMessage(exc, flow, StandardCharsets.UTF_8);
    }

    public Outcome validateMessage(Exchange exc, Interceptor.Flow flow, Charset ignored) throws Exception {
        Message msg = exc.getMessage(flow);
        ProcessingReport report = this.schema.validateUnchecked(om.readTree(msg.getBodyAsStreamDecoded()));
        if (report.isSuccess()) {
            this.valid.incrementAndGet();
            return Outcome.CONTINUE;
        }
        List<String> errors = JSONSchemaValidator.getErrors(report);
        if (this.failureHandler == ValidatorInterceptor.FailureHandler.VOID) {
            exc.setProperty("error", this.getErrorString(msg, errors));
            this.invalid.incrementAndGet();
            return Outcome.ABORT;
        }
        if (this.failureHandler != null) {
            this.failureHandler.handleFailure(this.getErrorString(msg, errors), exc);
            ProblemDetails.user(false, this.getName()).title(this.getErrorTitle()).addSubType("validation").buildAndSetResponse(exc);
            this.invalid.incrementAndGet();
            return Outcome.ABORT;
        }
        ProblemDetails.user(false, this.getName()).title(this.getErrorTitle()).addSubType("validation").component(this.getName()).internal("flow", flow.name()).internal("errors", errors).buildAndSetResponse(exc);
        this.invalid.incrementAndGet();
        return Outcome.ABORT;
    }

    @NotNull
    private static List<String> getErrors(ProcessingReport report) {
        return StreamSupport.stream(report.spliterator(), false).map(ProcessingMessage::getMessage).toList();
    }

    @NotNull
    private String getErrorString(Message msg, List<String> errors) {
        StringBuilder message = new StringBuilder();
        message.append(this.getSourceOfError(msg));
        message.append(": ");
        for (String error : errors) {
            message.append(error);
            message.append(";");
        }
        return message.toString();
    }

    private void createValidators() {
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        try {
            this.schema = factory.getJsonSchema(om.readTree(this.resolver.resolve(this.jsonSchema)));
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot create JSON Schema Validator for Schema: %s".formatted(this.jsonSchema), e);
        }
    }

    @Override
    public long getValid() {
        return this.valid.get();
    }

    @Override
    public long getInvalid() {
        return this.invalid.get();
    }

    @Override
    public String getErrorTitle() {
        return "JSON validation failed";
    }
}

