/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.schemavalidation;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.schemavalidation.JSONSchemaValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.MessageValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.SchematronValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.WSDLValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.XMLSchemaValidator;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.SOAPProxy;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.TextUtil;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@MCElement(name="validator")
public class ValidatorInterceptor
extends AbstractInterceptor
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger((String)ValidatorInterceptor.class.getName());
    private String wsdl;
    private String schema;
    private String serviceName;
    private String jsonSchema;
    private String schematron;
    private String failureHandler;
    private boolean skipFaults;
    private MessageValidator validator;
    private ResolverMap resourceResolver;
    private ApplicationContext applicationContext;

    public ValidatorInterceptor() {
        this.name = "validator";
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void init() {
        super.init();
        this.resourceResolver = this.router.getResolverMap();
        try {
            this.validator = this.getMessageValidator();
            this.validator.init();
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot create message validator.", e);
        }
        this.name = this.validator.getName();
        if (this.skipFaults && this.wsdl == null) {
            throw new ConfigurationException("validator/@skipFaults only makes sense with validator/@wsdl.");
        }
    }

    private MessageValidator getMessageValidator() throws Exception {
        if (this.wsdl != null) {
            return new WSDLValidator(this.resourceResolver, ResolverMap.combine(this.getBaseLocation(), this.wsdl), this.serviceName, this.createFailureHandler(), this.skipFaults);
        }
        if (this.schema != null) {
            return new XMLSchemaValidator(this.resourceResolver, ResolverMap.combine(this.getBaseLocation(), this.schema), this.createFailureHandler());
        }
        if (this.jsonSchema != null) {
            return new JSONSchemaValidator(this.resourceResolver, ResolverMap.combine(this.getBaseLocation(), this.jsonSchema), this.createFailureHandler());
        }
        if (this.schematron != null) {
            return new SchematronValidator(ResolverMap.combine(this.getBaseLocation(), this.schematron), this.createFailureHandler(), this.router, (BeanFactory)this.applicationContext);
        }
        WSDLValidator validator = this.getWsdlValidatorFromSOAPProxy();
        if (validator != null) {
            return validator;
        }
        throw new RuntimeException("Validator is not configured properly. <validator> must have an attribute specifying the validator.");
    }

    @Nullable
    private WSDLValidator getWsdlValidatorFromSOAPProxy() {
        Proxy proxy = this.router.getParentProxy(this);
        if (proxy instanceof SOAPProxy) {
            SOAPProxy sp = (SOAPProxy)proxy;
            this.wsdl = sp.getWsdl();
            this.name = "soap validator";
            return new WSDLValidator(this.resourceResolver, ResolverMap.combine(this.getBaseLocation(), this.wsdl), this.serviceName, this.createFailureHandler(), this.skipFaults);
        }
        return null;
    }

    @Nullable
    private String getBaseLocation() {
        return this.router == null ? null : this.router.getBaseLocation();
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.RESPONSE);
    }

    private Outcome handleInternal(Exchange exc, Interceptor.Flow flow) {
        try {
            if (exc.getMessage(flow).isBodyEmpty()) {
                return Outcome.CONTINUE;
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).addSubSee("io").detail("Could not read message body").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        try {
            return this.validator.validateMessage(exc, flow);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Error validating message").addSubSee("generic").internal("validator", this.validator.getName()).exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    @MCAttribute
    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public String getSchema() {
        return this.schema;
    }

    @MCAttribute
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getFailureHandler() {
        return this.failureHandler;
    }

    @MCAttribute
    public void setFailureHandler(String failureHandler) {
        this.failureHandler = failureHandler;
    }

    public String getJsonSchema() {
        return this.jsonSchema;
    }

    @MCAttribute
    public void setJsonSchema(String jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    public String getSchematron() {
        return this.schematron;
    }

    @MCAttribute
    public void setSchematron(String schematron) {
        this.schematron = schematron;
    }

    public boolean isSkipFaults() {
        return this.skipFaults;
    }

    @MCAttribute
    public void setSkipFaults(boolean skipFaults) {
        this.skipFaults = skipFaults;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @MCAttribute
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setResourceResolver(ResolverMap resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    @Override
    public String getShortDescription() {
        return this.validator.getInvalid() + " of " + (this.validator.getValid() + this.validator.getInvalid()) + " messages have been invalid.";
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder(this.getShortDescription());
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" according to ");
        if (this.wsdl != null) {
            sb.append("the WSDL at <br/>");
            sb.append(TextUtil.linkURL(this.wsdl));
        }
        if (this.schema != null) {
            sb.append("the XML Schema at <br/>");
            sb.append(TextUtil.linkURL(this.schema));
        }
        if (this.jsonSchema != null) {
            sb.append("the JSON Schema at <br/>");
            sb.append(TextUtil.linkURL(this.jsonSchema));
        }
        if (this.schematron != null) {
            sb.append("the Schematron at <br/>");
            sb.append(TextUtil.linkURL(this.schematron));
        }
        sb.append(" .");
        return sb.toString();
    }

    private FailureHandler createFailureHandler() {
        if (this.failureHandler == null || this.failureHandler.equals("response")) {
            return null;
        }
        if (this.failureHandler.equals("log")) {
            return (message, exc) -> log.info("Validation failure: {}", (Object)message);
        }
        throw new IllegalArgumentException("Unknown failureHandler type: " + this.failureHandler);
    }

    public static interface FailureHandler {
        public static final FailureHandler VOID = (message, exc) -> {};

        public void handleFailure(String var1, Exchange var2);
    }
}

