/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.schemavalidation;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.schemavalidation.AbstractXMLSchemaValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.ValidatorInterceptor;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.util.MessageUtil;
import com.predic8.membrane.core.util.SOAPUtil;
import com.predic8.membrane.core.util.WSDLUtil;
import com.predic8.schema.Schema;
import com.predic8.wsdl.Definitions;
import com.predic8.wsdl.Service;
import com.predic8.wsdl.Types;
import com.predic8.wsdl.WSDLParser;
import com.predic8.wsdl.WSDLParserContext;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSDLValidator
extends AbstractXMLSchemaValidator {
    private static final Logger log = LoggerFactory.getLogger((String)WSDLValidator.class.getName());
    private final String serviceName;
    private Set<QName> requestElements = new HashSet<QName>();
    private Set<QName> responseElements = new HashSet<QName>();
    private boolean checkIfSOAPElementIsUsedAsAWSDLMessage;
    private boolean soap11;
    private boolean soap12;

    public WSDLValidator(ResolverMap resourceResolver, String location, String serviceName, ValidatorInterceptor.FailureHandler failureHandler, boolean skipFaults) {
        super(resourceResolver, location, failureHandler, skipFaults);
        this.serviceName = serviceName;
    }

    @Override
    public String getName() {
        return "wsdl-validator";
    }

    @Override
    public Outcome validateMessage(Exchange exc, Interceptor.Flow flow) throws Exception {
        Message msg = exc.getMessage(flow);
        SOAPUtil.SOAPAnalysisResult result = SOAPUtil.analyseSOAPMessage(this.xopr, msg);
        if (result.version() == Constants.SoapVersion.SOAP11 && !this.soap11) {
            this.setErrorResponse(exc, "SOAP version 1.1 is not valid");
            return Outcome.ABORT;
        }
        if (result.version() == Constants.SoapVersion.SOAP12 && !this.soap12) {
            this.setErrorResponse(exc, "SOAP version 1.2 is not valid");
            return Outcome.ABORT;
        }
        if (this.checkIfSOAPElementIsUsedAsAWSDLMessage) {
            if (msg instanceof Request && !this.isPossibleRequestElement(result.soapElement())) {
                this.setErrorResponse(exc, "%s is not a valid request element. Possible elements are %s".formatted(result.soapElement(), this.requestElements));
                return Outcome.ABORT;
            }
            if (msg instanceof Response && !this.isPossibleResponseElement(result.soapElement())) {
                this.setErrorResponse(exc, "%s is not a valid response element. Possible elements are %s".formatted(result.soapElement(), this.requestElements));
                return Outcome.ABORT;
            }
        }
        return super.validateMessage(exc, flow);
    }

    private boolean isPossibleRequestElement(QName name) {
        return this.isPossibleSOAPElement(this.requestElements, name);
    }

    private boolean isPossibleResponseElement(QName name) {
        return this.isPossibleSOAPElement(this.responseElements, name);
    }

    private boolean isPossibleSOAPElement(Set<QName> elementNames, QName name) {
        return elementNames.stream().anyMatch(qn -> qn.equals(name));
    }

    @Override
    protected List<Schema> getSchemas() {
        WSDLParserContext ctx = new WSDLParserContext();
        ctx.setInput((Object)this.location);
        Definitions definitions = this.parseWsdl(ctx);
        this.readPossibleToplevelSOAPElements(definitions);
        return WSDLValidator.getSchemas(definitions);
    }

    private Definitions parseWsdl(WSDLParserContext ctx) {
        Definitions definitions;
        try {
            definitions = this.getWsdlParser().parse(ctx);
        }
        catch (NoSuchElementException e) {
            log.error(e.getMessage());
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof ResourceRetrievalException) {
                ResourceRetrievalException re = (ResourceRetrievalException)throwable;
                String msg = "Could not read WSDL from %s or its dependent XML Schemas.".formatted(this.location);
                log.error(msg);
                throw new IllegalStateException(msg, re);
            }
            log.error("Error downloading WSDL from {}.", (Object)this.location);
            throw e;
        }
        return definitions;
    }

    @NotNull
    private static List<Schema> getSchemas(Definitions definitions) {
        return definitions.getTypes().stream().map(Types::getSchemas).flatMap(Collection::stream).toList();
    }

    private void readPossibleToplevelSOAPElements(Definitions definitions) {
        if (this.serviceName != null) {
            this.checkIfSOAPElementIsUsedAsAWSDLMessage = true;
            Service service = WSDLUtil.getService(definitions, this.serviceName);
            this.determinePossibleSoapVersions(service);
            this.requestElements = WSDLUtil.getPossibleSOAPElements(service, WSDLUtil.Direction.REQUEST);
            this.responseElements = WSDLUtil.getPossibleSOAPElements(service, WSDLUtil.Direction.RESPONSE);
            return;
        }
        if (definitions.getServices().isEmpty()) {
            this.checkIfSOAPElementIsUsedAsAWSDLMessage = true;
            this.soap11 = true;
            this.soap12 = true;
            definitions.getPortTypes().forEach(portType -> {
                this.requestElements.addAll(WSDLUtil.getPossibleSOAPElements(portType, WSDLUtil.Direction.REQUEST));
                this.responseElements.addAll(WSDLUtil.getPossibleSOAPElements(portType, WSDLUtil.Direction.RESPONSE));
            });
            return;
        }
        definitions.getServices().forEach(this::determinePossibleSoapVersions);
    }

    private void determinePossibleSoapVersions(Service service) {
        service.getPorts().forEach(port -> {
            switch (WSDLUtil.getSOAPVersion(port)) {
                case SOAP11: {
                    this.soap11 = true;
                    break;
                }
                case SOAP12: {
                    this.soap12 = true;
                }
            }
        });
    }

    @NotNull
    private WSDLParser getWsdlParser() {
        WSDLParser parser = new WSDLParser();
        parser.setResourceResolver((Object)this.resolver.toExternalResolver().toExternalResolver());
        return parser;
    }

    @Override
    protected Source getMessageBody(InputStream input) {
        return MessageUtil.getSOAPBody(input);
    }

    @Override
    protected void setErrorResponse(Exchange exchange, String message) {
        exchange.setResponse(SOAPUtil.createSOAPFaultResponse(SOAPUtil.FaultCode.Client, this.getErrorTitle(), Map.of("error", message)));
    }

    @Override
    protected void setErrorResponse(Exchange exchange, Interceptor.Flow flow, List<Exception> exceptions) {
        exchange.setResponse(SOAPUtil.createSOAPFaultResponse(SOAPUtil.FaultCode.Client, this.getErrorTitle(), Map.of("validation", this.convertExceptionsToMap(exceptions))));
    }

    @Override
    protected boolean isFault(Message msg) {
        return SOAPUtil.analyseSOAPMessage(this.xopr, msg).isFault();
    }

    @Override
    protected String getPreliminaryError(XOPReconstitutor xopr, Message msg) {
        if (SOAPUtil.isSOAP(xopr, msg)) {
            return null;
        }
        return "Not a SOAP message.";
    }

    @Override
    public String getErrorTitle() {
        return "WSDL message validation failed";
    }
}

