/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.schemavalidation;

import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.schemavalidation.AbstractXMLSchemaValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.SchemaValidatorErrorHandler;
import com.predic8.membrane.core.interceptor.schemavalidation.ValidatorInterceptor;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.schema.Schema;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XMLSchemaValidator
extends AbstractXMLSchemaValidator {
    private static final Logger log = LoggerFactory.getLogger((String)XMLSchemaValidator.class.getName());

    public XMLSchemaValidator(ResolverMap resourceResolver, String location, ValidatorInterceptor.FailureHandler failureHandler) {
        super(resourceResolver, location, failureHandler);
        this.init();
    }

    @Override
    public String getName() {
        return "xml-schema-validator";
    }

    @Override
    protected List<Schema> getSchemas() {
        return null;
    }

    @Override
    protected List<Validator> createValidators() {
        Validator validator;
        StreamSource ss;
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setResourceResolver(this.resolver.toLSResourceResolver());
        ArrayList<Validator> validators = new ArrayList<Validator>();
        log.debug("Creating validator for schema: {}", (Object)this.location);
        try {
            ss = new StreamSource(this.resolver.resolve(this.location));
        }
        catch (ResourceRetrievalException e) {
            throw new ConfigurationException("Cannot resolve schema from %s.".formatted(this.location), e);
        }
        ss.setSystemId(this.location);
        try {
            validator = sf.newSchema(ss).newValidator();
        }
        catch (SAXException e) {
            throw new ConfigurationException("Cannot parse schema from %s.".formatted(this.location), e);
        }
        validator.setResourceResolver(this.resolver.toLSResourceResolver());
        validator.setErrorHandler(new SchemaValidatorErrorHandler());
        validators.add(validator);
        return validators;
    }

    @Override
    protected Source getMessageBody(InputStream input) {
        return new StreamSource(input);
    }

    @Override
    protected void setErrorResponse(Exchange exchange, String message) {
        ProblemDetails.user(false, this.getName()).title(this.getErrorTitle()).addSubType("validation").component(this.getName()).internal("error", message).buildAndSetResponse(exchange);
    }

    @Override
    protected void setErrorResponse(Exchange exchange, Interceptor.Flow flow, List<Exception> exceptions) {
        ProblemDetails.user(false, this.getName()).title(this.getErrorTitle()).internal("validation", this.convertExceptionsToMap(exceptions)).buildAndSetResponse(exchange);
        exchange.getResponse().getHeader().add("X-Validation-Error-Source", flow.name());
    }

    @Override
    protected boolean isFault(Message msg) {
        return false;
    }

    @Override
    protected String getPreliminaryError(XOPReconstitutor xopr, Message msg) {
        return null;
    }
}

