/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.security;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.security.SecureRandom;
import java.util.EnumSet;

@MCElement(name="paddingHeader")
public class PaddingHeaderInterceptor
extends AbstractInterceptor {
    static final String LOOKUP_TABLE = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 _:;.,\\/'?!(){}[]@<>=-+*#$&`|~^%";
    static final String X_PADDING = "X-Padding";
    private int roundUp = 20;
    private int constant = 5;
    private int random = 10;
    private final SecureRandom secRdm = new SecureRandom();

    private void setInterceptorMeta() {
        this.name = "padding header";
        this.setFlow(EnumSet.of(Interceptor.Flow.REQUEST, Interceptor.Flow.RESPONSE));
    }

    @Override
    public String getShortDescription() {
        return "Generates a randomized header field that artificially pads the message to protect against padding oracle attacks like CVE-2013-3587";
    }

    public PaddingHeaderInterceptor() {
        this.setInterceptorMeta();
    }

    public PaddingHeaderInterceptor(Integer roundUp, Integer constant, Integer random) {
        this.setInterceptorMeta();
        this.roundUp = roundUp;
        this.constant = constant;
        this.random = random;
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleInternal(exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleInternal(exc.getResponse());
    }

    private Outcome handleInternal(Message msg) {
        msg.getHeader().add(X_PADDING, this.headerSafePadding(this.calculatePaddingSize(msg)));
        return Outcome.CONTINUE;
    }

    public int calculatePaddingSize(Message msg) {
        return this.calculatePaddingSize(msg.estimateHeapSize());
    }

    public int calculatePaddingSize(long size) {
        return this.roundUp(size) + this.constant + this.getRandomNumber();
    }

    public int getRandomNumber() {
        return this.secRdm.nextInt(0, this.random);
    }

    public int roundUp(long n) {
        return (int)((long)this.roundUp - n % (long)this.roundUp);
    }

    public String headerSafePadding(int len) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            result.append(this.getRandomChar());
        }
        return result.toString();
    }

    private char getRandomChar() {
        return LOOKUP_TABLE.charAt(this.secRdm.nextInt(LOOKUP_TABLE.length()));
    }

    @MCAttribute
    public void setRoundUp(int roundUp) {
        this.roundUp = roundUp;
    }

    public Integer getRoundUp() {
        return this.roundUp;
    }

    @MCAttribute
    public void setConstant(int constant) {
        this.constant = constant;
    }

    public Integer getConstant() {
        return this.constant;
    }

    @MCAttribute
    public void setRandom(int random) {
        this.random = random;
    }

    public Integer getRandom() {
        return this.random;
    }
}

