/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.server;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.WSDLInterceptor;
import com.predic8.membrane.core.interceptor.server.WebServerInterceptor;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.SOAPProxy;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.util.HttpUtil;
import com.predic8.membrane.core.util.URLParamUtil;
import com.predic8.membrane.core.util.URLUtil;
import com.predic8.membrane.core.ws.relocator.Relocator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="wsdlPublisher")
public class WSDLPublisherInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WSDLPublisherInterceptor.class);
    private WebServerInterceptor webServerInterceptor;
    @GuardedBy(value="paths")
    private final HashMap<Integer, String> paths = new HashMap();
    @GuardedBy(value="paths")
    private final HashMap<String, Integer> paths_reverse = new HashMap();
    @GuardedBy(value="paths")
    private final Queue<String> documents_to_process = new LinkedList<String>();
    private String wsdl;

    public WSDLPublisherInterceptor() {
        this.name = "wsdl publisher";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDocuments(Exchange exc) {
        HashMap<Integer, String> hashMap = this.paths;
        synchronized (hashMap) {
            try {
                String doc;
                while ((doc = this.documents_to_process.poll()) != null) {
                    log.debug("WSDLPublisherInterceptor: processing {}", (Object)doc);
                    exc.setResponse(this.webServerInterceptor.createResponse(this.router.getResolverMap(), doc));
                    WSDLInterceptor wi = new WSDLInterceptor();
                    wi.setRewriteEndpoint(false);
                    wi.setPathRewriter(new RelativePathRewriter(exc, doc));
                    wi.handleResponse(exc);
                }
            }
            catch (Exception e) {
                log.error("Could not recursively load all documents referenced by {}.", (Object)this.wsdl, (Object)e);
            }
        }
    }

    public String getWsdl() {
        return this.wsdl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MCAttribute
    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
        HashMap<Integer, String> hashMap = this.paths;
        synchronized (hashMap) {
            this.paths.clear();
            this.paths_reverse.clear();
            this.documents_to_process.clear();
            this.documents_to_process.add(wsdl);
        }
    }

    @Override
    public void init() {
        super.init();
        this.webServerInterceptor = new WebServerInterceptor();
        this.webServerInterceptor.init(this.router);
        if (this.wsdl != null) {
            return;
        }
        this.getWSDLFromEmbeddingSOAPProxy();
    }

    private void getWSDLFromEmbeddingSOAPProxy() {
        Proxy proxy = this.router.getParentProxy(this);
        if (proxy instanceof SOAPProxy) {
            SOAPProxy sp = (SOAPProxy)proxy;
            this.wsdl = sp.getWsdl();
            this.setWsdl(this.wsdl);
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        try {
            return this.handleRequestInternal(exc);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Could not return WSDL document!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Outcome handleRequestInternal(Exchange exc) throws Exception {
        if (!exc.getRequest().isGETRequest()) {
            return Outcome.CONTINUE;
        }
        try {
            Map<String, String> params;
            String resource = null;
            if (exc.getRequestURI().endsWith("?wsdl") || exc.getRequestURI().endsWith("?WSDL")) {
                this.processDocuments(exc);
                resource = ResolverMap.combine(this.router.getBaseLocation(), this.wsdl);
                exc.setResponse(this.webServerInterceptor.createResponse(this.router.getResolverMap(), resource));
                exc.getResponse().getHeader().setContentType("text/xml");
            }
            if (exc.getRequestURI().contains("?xsd=") && (params = URLParamUtil.getParams(this.router.getUriFactory(), exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR)).containsKey("xsd")) {
                String path;
                int n = Integer.parseInt(params.get("xsd"));
                this.processDocuments(exc);
                HashMap<Integer, String> hashMap = this.paths;
                synchronized (hashMap) {
                    if (!this.paths.containsKey(n)) {
                        exc.setResponse(Response.forbidden("Unknown parameter. You may only retrieve documents referenced by the WSDL.").build());
                        return Outcome.ABORT;
                    }
                    path = this.paths.get(n);
                }
                resource = path;
                exc.setResponse(this.webServerInterceptor.createResponse(this.router.getResolverMap(), resource));
                exc.getResponse().getHeader().setContentType("text/xml");
            }
            if (resource != null) {
                WSDLInterceptor wi = new WSDLInterceptor();
                wi.setRewriteEndpoint(false);
                wi.setPathRewriter(new RelativePathRewriter(exc, ResolverMap.combine(this.router.getBaseLocation(), this.wsdl)));
                wi.init(this.router);
                wi.handleResponse(exc);
                return Outcome.RETURN;
            }
        }
        catch (NumberFormatException e) {
            exc.setResponse(HttpUtil.setHTMLErrorResponse(Response.internalServerError(), "Bad parameter format.", ""));
            return Outcome.ABORT;
        }
        catch (ResourceRetrievalException e) {
            exc.setResponse(Response.notFound().build());
            return Outcome.ABORT;
        }
        return Outcome.CONTINUE;
    }

    @Override
    public String getShortDescription() {
        return "Publishes the WSDL at " + this.wsdl + " under \"?wsdl\" (as well as its dependent schemas under similar URLs).";
    }

    private final class RelativePathRewriter
    implements Relocator.PathRewriter {
        private final Exchange exc;
        private final String resource;

        private RelativePathRewriter(Exchange exc, String resource) {
            this.exc = exc;
            this.resource = resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String rewrite(String path) {
            try {
                if (!((String)path).contains("://") && !((String)path).startsWith("/")) {
                    path = ResolverMap.combine(new String[]{this.resource, path});
                }
                HashMap<Integer, String> hashMap = WSDLPublisherInterceptor.this.paths;
                synchronized (hashMap) {
                    if (WSDLPublisherInterceptor.this.paths_reverse.containsKey(path)) {
                        path = WSDLPublisherInterceptor.this.paths_reverse.get(path).toString();
                    } else {
                        int n = WSDLPublisherInterceptor.this.paths.size() + 1;
                        WSDLPublisherInterceptor.this.paths.put(n, (String)path);
                        WSDLPublisherInterceptor.this.paths_reverse.put((String)path, n);
                        WSDLPublisherInterceptor.this.documents_to_process.add((String)path);
                        path = Integer.toString(n);
                    }
                }
                path = "./" + URLUtil.getName(WSDLPublisherInterceptor.this.router.getUriFactory(), this.exc.getDestinations().getFirst()) + "?xsd=" + (String)path;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return path;
        }
    }
}

