/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.server;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.util.HttpUtil;
import com.predic8.membrane.core.util.TextUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="webServer")
public class WebServerInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)WebServerInterceptor.class.getName());
    private static final String[] EMPTY = new String[0];
    String docBase = "docBase";
    boolean docBaseIsNormalized = false;
    String[] index = EMPTY;
    boolean generateIndex;

    public WebServerInterceptor() {
        this.name = "web server";
    }

    public WebServerInterceptor(Router r) {
        this.name = "web server";
        this.router = r;
    }

    @Override
    public void init() {
        super.init();
        this.normalizeDocBase();
    }

    private void normalizeDocBase() {
        this.docBase = this.docBase.replaceAll(Pattern.quote("\\"), "/");
        if (!this.docBaseIsNormalized) {
            if (!this.docBase.endsWith(File.separator)) {
                this.docBase = this.docBase + "/";
            }
            try {
                this.docBase = this.getAbsolutePathWithSchemePrefix(this.docBase);
            }
            catch (Exception e) {
                log.error("While handling docBase={}", (Object)this.docBase, (Object)e);
            }
            this.docBaseIsNormalized = true;
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        try {
            return this.handleRequestInternal(exc);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).flow(Interceptor.Flow.REQUEST).detail("Error serving document").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    @NotNull
    private Outcome handleRequestInternal(Exchange exc) throws IOException {
        String uri;
        this.normalizeDocBase();
        try {
            uri = this.getUri(exc);
        }
        catch (URISyntaxException e) {
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).addSubSee("uri-creation").detail("Could not create uri").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        if (uri == null) {
            return Outcome.ABORT;
        }
        try {
            exc.setTimeReqSent(System.currentTimeMillis());
            exc.setResponse(this.createResponse(this.router.getResolverMap(), ResolverMap.combine(this.router.getBaseLocation(), this.docBase, uri)));
            exc.setReceived();
            exc.setTimeResReceived(System.currentTimeMillis());
            return Outcome.RETURN;
        }
        catch (Exception e) {
            Outcome outcome;
            if (this.tryToReceiveResource(exc, uri)) {
                return Outcome.RETURN;
            }
            if (this.tryToReceiveResource(exc, uri + "/")) {
                return Outcome.RETURN;
            }
            if (this.generateIndex && (outcome = this.generateHtmlResponseFromChildren(exc, uri)) != null) {
                return outcome;
            }
            exc.setResponse(Response.notFound().build());
            return Outcome.ABORT;
        }
    }

    private boolean tryToReceiveResource(Exchange exc, String uri) {
        for (String i : this.index) {
            try {
                exc.setResponse(this.createResponse(this.router.getResolverMap(), ResolverMap.combine(this.router.getBaseLocation(), this.docBase, uri + i)));
                exc.setReceived();
                exc.setTimeResReceived(System.currentTimeMillis());
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    @Nullable
    private String getUri(Exchange exc) throws URISyntaxException {
        String uri = this.router.getUriFactory().create(exc.getDestinations().getFirst()).getPath();
        log.debug("request: {}", (Object)uri);
        if (this.escapesPath(uri) || this.escapesPath(this.router.getUriFactory().create(uri).getPath())) {
            exc.setResponse(Response.badRequest().body("").build());
            return null;
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        return uri;
    }

    private Outcome generateHtmlResponseFromChildren(Exchange exc, String uri) throws FileNotFoundException {
        List<String> children = this.router.getResolverMap().getChildren(ResolverMap.combine(this.router.getBaseLocation(), this.docBase, uri));
        if (children == null) {
            return null;
        }
        Collections.sort(children);
        exc.setResponse(Response.ok().contentType("text/html").body(this.generateHtmlContent(children, this.determineBaseUri(exc, uri))).build());
        return Outcome.RETURN;
    }

    private String determineBaseUri(Exchange exc, String uri) {
        if (uri.endsWith("/")) {
            return "";
        }
        String base = exc.getRequestURI();
        int lastSlashPos = base.lastIndexOf(47);
        if (lastSlashPos != -1) {
            base = base.substring(lastSlashPos + 1);
        }
        return (base.isEmpty() ? "." : base) + "/";
    }

    private String generateHtmlContent(List<String> children, String baseUri) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><tt>");
        for (String child : children) {
            sb.append(String.format("<a href=\"%s%s\">%s</a><br/>", baseUri, child, child));
        }
        sb.append("</tt></body></html>");
        return sb.toString();
    }

    private boolean escapesPath(String uri) {
        return uri.endsWith("..") || uri.endsWith("../") || uri.endsWith("..\\") || uri.contains("/../") || uri.contains("..\\") || uri.contains(":/") || uri.contains("file:\\") || uri.startsWith("..");
    }

    public Response createResponse(ResolverMap rr, String resPath) {
        try {
            return Response.ok().header(HttpUtil.createHeaders(WebServerInterceptor.getContentType(resPath), new String[0])).body(rr.resolve(resPath), true).build();
        }
        catch (Exception e) {
            return ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).title("Could not resolve file").topLevel("path", resPath).exception(e).build();
        }
    }

    private static String getContentType(String uri) {
        if (uri.endsWith(".css")) {
            return "text/css";
        }
        if (uri.endsWith(".js")) {
            return "application/javascript";
        }
        if (uri.endsWith(".wsdl")) {
            return "text/xml";
        }
        if (uri.endsWith(".xml")) {
            return "text/xml";
        }
        if (uri.endsWith(".xsd")) {
            return "text/xml";
        }
        if (uri.endsWith(".html")) {
            return "text/html";
        }
        if (uri.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (uri.endsWith(".png")) {
            return "image/png";
        }
        if (uri.endsWith(".json")) {
            return "application/json";
        }
        if (uri.endsWith(".svg")) {
            return "image/svg+xml";
        }
        return null;
    }

    public String getDocBase() {
        return this.docBase;
    }

    @MCAttribute
    @Required
    public void setDocBase(String docBase) {
        this.docBase = docBase;
        this.docBaseIsNormalized = false;
    }

    private String getAbsolutePathWithSchemePrefix(String path) {
        try {
            Path p = Paths.get(path, new String[0]);
            if (p.isAbsolute()) {
                return p.toUri().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getNewPath(path);
    }

    @NotNull
    private String getNewPath(String path) {
        String newPath = ResolverMap.combine(this.router.getBaseLocation(), path);
        if (newPath.endsWith(File.separator + File.separator)) {
            newPath = newPath.substring(0, newPath.length() - 1);
        }
        if (!newPath.endsWith("/")) {
            return newPath + "/";
        }
        return newPath;
    }

    public String getIndex() {
        return StringUtils.join((Object[])this.index, (String)",");
    }

    @MCAttribute
    public void setIndex(String i) {
        this.index = i == null ? EMPTY : i.split(",");
    }

    public boolean isGenerateIndex() {
        return this.generateIndex;
    }

    @MCAttribute
    public void setGenerateIndex(boolean generateIndex) {
        this.generateIndex = generateIndex;
    }

    @Override
    public String getShortDescription() {
        return "Serves static files from<br/>" + TextUtil.linkURL(this.docBase) + " .";
    }
}

