/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.session;

import com.bornium.security.oauth2openid.token.IdTokenProvider;
import com.bornium.security.oauth2openid.token.IdTokenVerifier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.security.Blob;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.interceptor.session.SessionManager;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="jwtSessionManager")
public class JwtSessionManager
extends SessionManager {
    private static final Logger log = LoggerFactory.getLogger(JwtSessionManager.class);
    private Cache<Map, String> jwtCache;
    private SecureRandom random = new SecureRandom();
    private RsaJsonWebKey rsaJsonWebKey;
    private Duration validTime;
    private Duration renewalTime;
    private Duration jwtCacheTime = Duration.ofMinutes(2L);
    IdTokenProvider idTokenProvider;
    IdTokenVerifier idTokenVerifier;
    Jwk jwk;
    boolean verbose = false;

    @Override
    public void init(Router router) throws Exception {
        if (this.validTime == null) {
            this.validTime = Duration.ofSeconds(this.expiresAfterSeconds);
        }
        if (this.renewalTime == null) {
            this.renewalTime = this.validTime.dividedBy(3L);
        }
        if (this.jwk == null) {
            this.rsaJsonWebKey = this.generateKey();
            log.warn("jwtSessionManager uses a generated key ('{}'). Sessions of this instance\nwill not be compatible with sessions of other (e.g. restarted)\ninstances. To solve this, write the JWK into a file and reference it using <jwtSessionManager><jwk location=\"...\">.\n", (Object)this.rsaJsonWebKey.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE));
        } else {
            this.rsaJsonWebKey = new RsaJsonWebKey(JsonUtil.parseJson((String)this.jwk.get(router.getResolverMap(), router.getBaseLocation())));
        }
        this.idTokenProvider = new IdTokenProvider(this.rsaJsonWebKey);
        this.idTokenVerifier = new IdTokenVerifier(this.idTokenProvider.getJwk());
        this.jwtCache = CacheBuilder.newBuilder().expireAfterWrite(this.jwtCacheTime.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    private RsaJsonWebKey generateKey() throws JoseException {
        RsaJsonWebKey rsaJsonWebKey = RsaJwkGenerator.generateJwk((int)2048);
        rsaJsonWebKey.setKeyId(new BigInteger(130, this.random).toString(32));
        rsaJsonWebKey.setUse("sig");
        rsaJsonWebKey.setAlgorithm("RS256");
        return rsaJsonWebKey;
    }

    @Override
    protected Map<String, Object> cookieValueToAttributes(String cookie) {
        try {
            return this.idTokenVerifier.createCustomJwtValidator().setSkipSignatureVerification().build().processToClaims(this.getCookieKey(cookie)).getClaimsMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (InvalidJwtException e) {
            log.warn("Could not verify cookie: {}\nPossible Reason: Cookie is not signed by and thus not a session of this instance", (Object)cookie);
            e.printStackTrace();
            return new HashMap<String, Object>();
        }
    }

    private String getCookieKey(String cookie) {
        return cookie.split("=")[0].trim();
    }

    @Override
    protected Map<Session, String> getCookieValues(Session ... sessions) {
        return Stream.of(sessions).collect(Collectors.toMap(s -> s, this::createJwtRepresentation));
    }

    private String createJwtRepresentation(Session s) {
        try {
            Map filteredSession = this.filterSession(s.get());
            String token = (String)this.jwtCache.getIfPresent((Object)filteredSession);
            if (token != null) {
                log.debug("reusing cookie for: {}", (Object)filteredSession);
                return token;
            }
            log.debug("encoding cookie: {}", (Object)filteredSession);
            token = this.idTokenProvider.createIdTokenNoNullClaims(this.issuer, null, null, this.validTime, null, null, new HashMap(filteredSession));
            this.jwtCache.put((Object)filteredSession, (Object)token);
            return token;
        }
        catch (JoseException e) {
            throw new RuntimeException("Could not create JWT representation of session", e);
        }
    }

    private Map filterSession(Map<String, Object> stringObjectMap) {
        HashMap<String, Object> result = new HashMap<String, Object>(stringObjectMap);
        Stream.of("iss", "exp", "nbf", "iat").forEach(result::remove);
        return result;
    }

    @Override
    public List<String> getInvalidCookies(Exchange exc, String validCookie) {
        return Stream.of(this.getAllCookieKeys(exc)).map(this::getCookieKey).filter(cookie -> {
            try {
                this.checkJwtWithoutVerifyingSignature((String)cookie);
                return true;
            }
            catch (InvalidJwtException e) {
                if (this.verbose) {
                    e.printStackTrace();
                }
                return false;
            }
        }).filter(cookie -> !cookie.equals(this.getKeyOfCookie(validCookie))).map(this::addValueToCookie).collect(Collectors.toList());
    }

    @Override
    protected boolean isValidCookieForThisSessionManager(String cookie) {
        try {
            cookie = this.getCookieKey(cookie);
            this.checkJwtWithoutVerifyingSignature(cookie);
            this.validateSignatureOfJwt(cookie);
            return true;
        }
        catch (InvalidJwtException e) {
            if (this.verbose) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    protected boolean cookieRenewalNeeded(String originalCookie) {
        try {
            JwtClaims claims = this.processToClaims(originalCookie);
            return Instant.ofEpochSecond(claims.getIssuedAt().getValue()).plus(this.renewalTime).isBefore(Instant.now());
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void validateSignatureOfJwt(String cookie) throws InvalidJwtException {
        this.idTokenVerifier.createCustomJwtValidator().setExpectedIssuer(this.issuer).build().processToClaims(cookie);
    }

    private void checkJwtWithoutVerifyingSignature(String cookie) throws InvalidJwtException {
        new JwtConsumerBuilder().setSkipSignatureVerification().setExpectedIssuer(this.issuer).setRequireExpirationTime().build().processToClaims(cookie);
    }

    private JwtClaims processToClaims(String cookie) throws InvalidJwtException {
        return new JwtConsumerBuilder().setSkipSignatureVerification().build().processToClaims(cookie);
    }

    private String addValueToCookie(String cookie) {
        return cookie + "=true";
    }

    private String getKeyOfCookie(String validCookie) {
        return validCookie.split("=true")[0];
    }

    public Jwk getJwk() {
        return this.jwk;
    }

    @MCChildElement
    public void setJwk(Jwk jwk) {
        this.jwk = jwk;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @MCAttribute
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Duration getValidTime() {
        return this.validTime;
    }

    public void setValidTime(Duration validTime) {
        this.validTime = validTime;
    }

    public Duration getRenewalTime() {
        return this.renewalTime;
    }

    public void setRenewalTime(Duration renewalTime) {
        this.renewalTime = renewalTime;
    }

    public Duration getJwtCacheTime() {
        return this.jwtCacheTime;
    }

    public void setJwtCacheTime(Duration jwtCacheTime) {
        this.jwtCacheTime = jwtCacheTime;
    }

    @MCElement(name="jwk", mixed=true, topLevel=false, id="jwtSessionManager-jwk")
    public static class Jwk
    extends Blob {
    }
}

