/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.session;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.interceptor.session.Session;
import com.predic8.membrane.core.interceptor.session.SessionManager;
import com.predic8.membrane.core.util.MemcachedConnector;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.exception.MemcachedException;

@MCElement(name="memcachedSessionManager")
public class MemcachedSessionManager
extends SessionManager {
    private MemcachedConnector connector;
    private MemcachedClient client;
    protected String cookiePrefix = UUID.randomUUID().toString().substring(0, 8);
    private static final String ID_NAME = "_in_memory_session_id";
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void init(Router router) throws Exception {
        this.client = this.connector.getClient();
    }

    @Override
    protected Map<String, Object> cookieValueToAttributes(String cookie) {
        return this.getCachedSession(cookie).map(this::parse).orElse(new Session(this.usernameKeyName, new HashMap<String, Object>())).get();
    }

    private Session parse(String json) {
        try {
            return (Session)this.objectMapper.readValue(json, Session.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Map<Session, String> getCookieValues(Session ... session) {
        this.createNewSessions(session);
        this.fixMergedSessionId(session);
        this.addSessions(session);
        return Arrays.stream(session).collect(Collectors.toMap(Function.identity(), s -> (String)s.get(ID_NAME)));
    }

    private void addSessions(Session[] sessions) {
        Arrays.stream(sessions).forEach(s -> {
            try {
                this.client.set((String)s.get(ID_NAME), Math.toIntExact(this.getExpiresAfterSeconds()), (Object)this.stringify((Session)s));
            }
            catch (InterruptedException | TimeoutException | MemcachedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private String stringify(Session session) {
        try {
            return this.objectMapper.writeValueAsString((Object)session);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private void fixMergedSessionId(Session[] sessions) {
        Arrays.stream(sessions).filter(s -> s.get(ID_NAME).toString().contains(",")).forEach(s -> s.put(ID_NAME, this.getNewSessionId()));
    }

    private void createNewSessions(Session[] sessions) {
        Arrays.stream(sessions).filter(this::isNewSession).forEach(this::createSessionId);
    }

    private void createSessionId(Session session) {
        session.put(ID_NAME, this.getNewSessionId());
    }

    private String getNewSessionId() {
        return this.cookiePrefix + "-" + String.valueOf(UUID.randomUUID());
    }

    private boolean isNewSession(Session session) {
        return session.get(ID_NAME) == null;
    }

    @Override
    public List<String> getInvalidCookies(Exchange exc, String validCookie) {
        return MemcachedSessionManager.getCookieHeaderFields(exc).stream().map(HeaderField::getValue).flatMap(s -> Arrays.stream(s.split(";"))).map(String::trim).filter(value -> this.isInvalidCookie((String)value, validCookie)).toList();
    }

    @Override
    protected boolean isValidCookieForThisSessionManager(String cookie) {
        return this.isOwnedBySessionManager(cookie) && this.cookieRenewalNeeded(cookie);
    }

    @Override
    protected boolean cookieRenewalNeeded(String originalCookie) {
        return this.getCachedSession(originalCookie).isPresent();
    }

    @Override
    public void removeSession(Exchange exc) {
        this.getInvalidCookies(exc, UUID.randomUUID().toString()).forEach(key -> {
            try {
                this.client.delete(key);
            }
            catch (InterruptedException | TimeoutException | MemcachedException e) {
                throw new RuntimeException(e);
            }
        });
        super.removeSession(exc);
    }

    private boolean isInvalidCookie(String cookie, String validCookie) {
        return this.isOwnedBySessionManager(cookie) && !cookie.contains(validCookie);
    }

    private boolean isOwnedBySessionManager(String cookie) {
        return cookie.startsWith(this.cookiePrefix);
    }

    private Optional<String> getCachedSession(String cookie) {
        try {
            return Optional.ofNullable((String)this.client.get(cookie.split("=true")[0]));
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            throw new RuntimeException(e);
        }
    }

    public MemcachedConnector getConnector() {
        return this.connector;
    }

    @MCAttribute
    public void setConnector(MemcachedConnector connector) {
        this.connector = connector;
    }

    public String getCookiePrefix() {
        return this.cookiePrefix;
    }

    @MCAttribute
    public void setCookiePrefix(String cookiePrefix) {
        this.cookiePrefix = cookiePrefix;
    }
}

