/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.shadowing;

import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.MessageObserver;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.proxies.AbstractServiceProxy;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.util.URIFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="shadowing")
public class ShadowingInterceptor
extends AbstractInterceptor {
    private static final HttpClient client = new HttpClient();
    private static final Logger log = LoggerFactory.getLogger(ShadowingInterceptor.class);
    private List<AbstractServiceProxy.Target> targets = new ArrayList<AbstractServiceProxy.Target>();

    @Override
    public Outcome handleRequest(final Exchange exc) {
        final Header copiedHeader = new Header(exc.getRequest().getHeader());
        exc.getRequest().getBody().getObservers().add(new MessageObserver(){

            @Override
            public void bodyRequested(AbstractBody body) {
            }

            @Override
            public void bodyChunk(Chunk chunk) {
            }

            @Override
            public void bodyChunk(byte[] buffer, int offset, int length) {
            }

            @Override
            public void bodyComplete(AbstractBody completeBody) {
                ShadowingInterceptor.this.cloneRequestAndSend(completeBody, exc, copiedHeader);
            }
        });
        return Outcome.CONTINUE;
    }

    @Override
    public String getShortDescription() {
        return "Sends requests to shadow hosts (processed in the background).";
    }

    public void cloneRequestAndSend(AbstractBody completeBody, Exchange mainExchange, Header copiedHeader) {
        try (ExecutorService executor = Executors.newCachedThreadPool();){
            for (AbstractServiceProxy.Target shadowTarget : this.targets) {
                Exchange newExchange;
                try {
                    newExchange = ShadowingInterceptor.buildExchange(completeBody, mainExchange, shadowTarget, copiedHeader);
                }
                catch (Exception e) {
                    log.error("Error creating request for target {}", (Object)shadowTarget, (Object)e);
                    continue;
                }
                executor.submit(() -> {
                    try {
                        Exchange res = ShadowingInterceptor.performCall(newExchange);
                        if (res.getResponse().getStatusCode() >= 500) {
                            log.info("{} returned StatusCode {}", (Object)res.getDestinations().getFirst(), (Object)res.getResponse().getStatusCode());
                        }
                    }
                    catch (Exception e) {
                        log.error("Error performing call for target {}", (Object)shadowTarget, (Object)e);
                    }
                });
            }
        }
    }

    static Exchange buildExchange(AbstractBody completeBody, Exchange mainExchange, AbstractServiceProxy.Target shadowTarget, Header copiedHeader) throws URISyntaxException, IOException {
        return new Request.Builder().body(completeBody.getContent()).header(copiedHeader).method(mainExchange.getRequest().getMethod()).url(new URIFactory(), ShadowingInterceptor.getDestFromTarget(shadowTarget, mainExchange.getOriginalRequestUri())).buildExchange();
    }

    static String getDestFromTarget(AbstractServiceProxy.Target t, String path) {
        return t.getUrl() != null ? t.getUrl() : ShadowingInterceptor.buildTargetUrl(t, path);
    }

    private static String buildTargetUrl(AbstractServiceProxy.Target t, String path) {
        return (t.getSslParser() != null ? "https://" : "http://") + t.getHost() + ":" + t.getPort() + (path != null ? path : "");
    }

    static Exchange performCall(Exchange exchange) {
        try {
            return client.call(exchange);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @MCChildElement
    public void setTargets(List<AbstractServiceProxy.Target> targets) {
        this.targets = targets;
    }

    public List<AbstractServiceProxy.Target> getTargets() {
        return this.targets;
    }
}

