/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.shutdown;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;

@MCElement(name="shutdown")
public class ShutdownInterceptor
extends AbstractInterceptor {
    public ShutdownInterceptor() {
        this.name = "shutdown interceptor";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        if (this.getRouter().isRunning()) {
            exc.setResponse(Response.ok("Router shutdown procedure was started.").build());
            new Thread(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.getRouter().stop();
            }).start();
        } else {
            exc.setResponse(Response.serviceUnavailable("Router is not started.").build());
        }
        return Outcome.RETURN;
    }

    @Override
    public String getShortDescription() {
        return "Triggers Membrane to initiate a shutdown.";
    }

    @Override
    public String getLongDescription() {
        return "Triggers Membrane to initiate a shutdown.<br/>Note that the shutdown is triggered asynchronously after 100ms to allow the shutdown HTTP request to be completed successfully.<br/>Also note that the shutdown is not immediate, but pending HTTP Exchanges are given a grace period to complete.";
    }
}

