/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.soap;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.openapi.util.Utils;
import com.predic8.membrane.core.util.XMLUtil;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@MCElement(name="sampleSoapService")
public class SampleSoapServiceInterceptor
extends AbstractInterceptor {
    public static final Pattern WSDL_PATH_PARAM = Pattern.compile("(?i).*\\?.*wsdl.*");
    public static final String CITY_SERVICE_NS = "https://predic8.de/cities";
    private static final HashMap<String, City> cityMap = new HashMap<String, City>(){
        {
            this.put("Bonn", new City("Bonn", 327000, "Germany"));
            this.put("Bielefeld", new City("Bielefeld", 333000, "Germany"));
            this.put("Manila", new City("Manila", 1780000, "Philippines"));
            this.put("Da Nang", new City("Da Nang", 1220000, "Vietnam"));
            this.put("London", new City("London", 8980000, "England"));
            this.put("New York", new City("New York", 8460000, "USA"));
        }
    };

    public SampleSoapServiceInterceptor() {
        this.name = "sample soap service";
    }

    @Override
    public String getShortDescription() {
        return "Provides a simple SOAP service for testing and demonstration purposes.";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        try {
            return this.handleRequestInternal(exc);
        }
        catch (Exception e) {
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Could not process SOAP request!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    private Outcome handleRequestInternal(Exchange exc) throws Exception {
        if (SampleSoapServiceInterceptor.isWSDLRequest(exc)) {
            exc.setResponse(this.createWSDLResponse(exc));
            return Outcome.RETURN;
        }
        if (!exc.getRequest().isPOSTRequest()) {
            exc.setResponse(SampleSoapServiceInterceptor.createMethodNotAllowedSOAPFault(exc.getRequest().getMethod()));
            return Outcome.RETURN;
        }
        try {
            exc.setResponse(SampleSoapServiceInterceptor.createGetCityResponse(exc));
        }
        catch (Exception e) {
            exc.setResponse(SampleSoapServiceInterceptor.createResourceNotFoundSOAPFault());
        }
        return Outcome.RETURN;
    }

    private static Response createResourceNotFoundSOAPFault() {
        return Response.ok(SampleSoapServiceInterceptor.getSoapFault("Resource Not Found", "404", "Cannot parse SOAP message. Request should contain e.g. <name>Bonn</name>")).contentType("text/xml").build();
    }

    private static Response createGetCityResponse(Exchange exc) throws Exception {
        return Response.ok(SampleSoapServiceInterceptor.getResponse(SampleSoapServiceInterceptor.getCity(exc))).contentType("text/xml").build();
    }

    private static Response createMethodNotAllowedSOAPFault(String method) {
        return Response.ok(SampleSoapServiceInterceptor.getSoapFault("Method %s not allowed".formatted(method), "405", "Use POST to access the service.")).contentType("text/xml").build();
    }

    private Response createWSDLResponse(Exchange exc) throws XMLStreamException, FileNotFoundException {
        return Response.ok().header("Content-Type", "text/xml;charset=UTF-8").body(SampleSoapServiceInterceptor.setWsdlServer(Utils.getResourceAsStream(this, "/wsdl/city.wsdl"), exc)).build();
    }

    static boolean isWSDLRequest(Exchange exc) {
        return WSDL_PATH_PARAM.matcher(exc.getRequest().getUri()).matches();
    }

    private static String getCity(Exchange exc) throws Exception {
        return SampleSoapServiceInterceptor.getElementAsString(exc.getRequest().getBodyAsStream(), "name");
    }

    public static String getSoapFault(String faultString, String code, String errorMessage) {
        return "    <s11:Envelope xmlns:s11=\"http://schemas.xmlsoap.org/soap/envelope/\">\n        <s11:Body>\n            <s11:Fault>\n                <faultcode>s11:Client</faultcode>\n                <faultstring>%s</faultstring>\n                <detail>\n                    <errorcode>%s</errorcode>\n                    <errormessage>%s</errormessage>\n                </detail>\n            </s11:Fault>\n        </s11:Body>\n    </s11:Envelope>\n".formatted(faultString, code, errorMessage);
    }

    public static String getElementAsString(InputStream is, String localName) throws Exception {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(is);
        while (reader.hasNext()) {
            if (reader.next() != 1 || !reader.getName().getLocalPart().equals(localName)) continue;
            return reader.getElementText();
        }
        throw new Exception();
    }

    public static String setWsdlServer(InputStream is, Exchange exc) throws XMLStreamException {
        StringWriter modifiedXmlWriter = new StringWriter();
        XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(Objects.requireNonNull(is));
        XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(modifiedXmlWriter);
        XMLEventFactory fac = XMLEventFactory.newInstance();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement startElement = event.asStartElement();
                if ("address".equals(startElement.getName().getLocalPart())) {
                    writer.add(fac.createStartElement("s", "soap", "address"));
                    writer.add(fac.createAttribute("location", SampleSoapServiceInterceptor.getSOAPAddress(exc)));
                    continue;
                }
                writer.add(event);
                continue;
            }
            writer.add(event);
        }
        return modifiedXmlWriter.toString();
    }

    public static String getSOAPAddress(Exchange exc) {
        return exc.getInboundProtocol() + "://" + exc.getRequest().getHeader().getHost() + SampleSoapServiceInterceptor.getPathWithoutParam(exc.getOriginalRequestUri());
    }

    static String getPathWithoutParam(String uri) {
        return uri.replaceAll("\\?.*$", "");
    }

    public static String getResponse(String city) {
        try {
            return XMLUtil.xml2string(SampleSoapServiceInterceptor.createResponse(city));
        }
        catch (Exception e) {
            return SampleSoapServiceInterceptor.getSoapFault("Not Found", "404", "Do not know %s. Try Bonn, London or New York".formatted(city));
        }
    }

    private static Document createResponse(String city) throws Exception {
        Document res = SampleSoapServiceInterceptor.createDocumentBuilder().newDocument();
        res.appendChild(SampleSoapServiceInterceptor.createResponseEnvelope(city, res));
        return res;
    }

    private static Element createResponseEnvelope(String city, Document res) {
        Element env = res.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "s:Envelope");
        env.setAttribute("xmlns:s", "http://schemas.xmlsoap.org/soap/envelope/");
        env.setAttribute("xmlns:cs", CITY_SERVICE_NS);
        env.appendChild(SampleSoapServiceInterceptor.createBody(city, res));
        return env;
    }

    private static Element createBody(String city, Document res) {
        Element body = res.createElement("s:Body");
        body.appendChild(SampleSoapServiceInterceptor.createCityDetails(city, res));
        return body;
    }

    private static Element createCityDetails(String city, Document res) {
        Element details = res.createElement("cs:getCityResponse");
        details.appendChild(SampleSoapServiceInterceptor.createCountry(city, res));
        details.appendChild(SampleSoapServiceInterceptor.createPopulation(city, res));
        return details;
    }

    private static Element createPopulation(String city, Document res) {
        Element pop = res.createElement("population");
        pop.appendChild(res.createTextNode(String.valueOf(SampleSoapServiceInterceptor.cityMap.get((Object)city).population)));
        return pop;
    }

    private static Element createCountry(String city, Document res) {
        Element country = res.createElement("country");
        country.appendChild(res.createTextNode(SampleSoapServiceInterceptor.cityMap.get((Object)city).country));
        return country;
    }

    private static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    public record City(String name, int population, String country) {
    }
}

