/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.statistics;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchange.ExchangesUtil;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="statisticsCSV")
public class StatisticsCSVInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)StatisticsCSVInterceptor.class.getName());
    private static final Map<String, String> fileNames = new HashMap<String, String>();
    private String fileName = "";

    public StatisticsCSVInterceptor() {
        this.name = "csv logging";
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        log.debug("logging statistics to {}", (Object)new File(this.fileName).getAbsolutePath());
        try {
            this.writeExchange(exc);
        }
        catch (Exception e) {
            log.error("Error while logging statistics", (Throwable)e);
        }
        return Outcome.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExchange(Exchange exc) throws Exception {
        String string = this.fileName;
        synchronized (string) {
            try (FileOutputStream fos = new FileOutputStream(this.fileName, true);){
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                this.writeCSV(ExchangesUtil.getStatusCode(exc), w);
                this.writeCSV(ExchangesUtil.getTime(exc), w);
                this.writeCSV(exc.getProxy().toString(), w);
                this.writeCSV(exc.getRequest().getMethod(), w);
                this.writeCSV(exc.getRequest().getUri(), w);
                this.writeCSV(exc.getRemoteAddr(), w);
                this.writeCSV(exc.getServer(), w);
                this.writeCSV(exc.getRequestContentType(), w);
                this.writeCSV(ExchangesUtil.getRequestContentLength(exc), w);
                this.writeCSV(ExchangesUtil.getResponseContentType(exc), w);
                this.writeCSV(ExchangesUtil.getResponseContentLength(exc), w);
                this.writeCSV(ExchangesUtil.getTimeDifference(exc), w);
                this.writeNewLine(w);
                w.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MCAttribute(attributeName="file")
    @Required
    public void setFileName(String fileName) throws Exception {
        Map<String, String> map = fileNames;
        synchronized (map) {
            String fn = fileNames.get(fileName);
            if (fn != null) {
                fileName = fn;
            } else {
                fileNames.put(fileName, fileName);
            }
            this.fileName = fileName;
            this.createCSVFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCSVFile() throws Exception {
        String string = this.fileName;
        synchronized (string) {
            File csvFile = new File(this.fileName);
            log.debug("creating csv file at {}", (Object)csvFile.getAbsolutePath());
            if (csvFile.getParentFile() != null) {
                csvFile.getParentFile().mkdirs();
            }
            csvFile.createNewFile();
            if (!csvFile.canWrite()) {
                throw new IOException("File " + this.fileName + " is not writable.");
            }
            if (csvFile.length() == 0L) {
                this.writeHeaders();
            }
        }
    }

    public String getFileName() {
        return new File(this.fileName).getName();
    }

    private void writeCSV(String value, OutputStreamWriter w) throws IOException {
        w.append(value).append(";");
    }

    private void writeNewLine(OutputStreamWriter w) throws IOException {
        w.append(System.lineSeparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeaders() throws Exception {
        String string = this.fileName;
        synchronized (string) {
            try (FileOutputStream fos = new FileOutputStream(this.fileName, true);){
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                this.writeCSV("Status Code", w);
                this.writeCSV("Time", w);
                this.writeCSV("Rule", w);
                this.writeCSV("Method", w);
                this.writeCSV("Path", w);
                this.writeCSV("Client", w);
                this.writeCSV("Server", w);
                this.writeCSV("Request Content-Type", w);
                this.writeCSV("Request Content Length", w);
                this.writeCSV("Response Content-Type", w);
                this.writeCSV("Response Content Length", w);
                this.writeCSV("Duration", w);
                this.writeNewLine(w);
                w.flush();
            }
        }
    }

    @Override
    public String getShortDescription() {
        return "Logs access statistics into the CSV-based file " + StringEscapeUtils.escapeHtml4((String)this.fileName) + " .";
    }
}

