/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.statistics;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.statistics.util.JDBCUtil;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.ParseException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Objects;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@MCElement(name="statisticsJDBC")
public class StatisticsJDBCInterceptor
extends AbstractInterceptor
implements ApplicationContextAware {
    private static final String DATASOURCE_BEAN_ID_ATTRIBUTE_CANNOT_BE_USED = "datasource bean id attribute cannot be used";
    private static final Logger log = LoggerFactory.getLogger((String)StatisticsJDBCInterceptor.class.getName());
    private ApplicationContext applicationContext;
    private DataSource dataSource;
    private boolean postMethodOnly;
    private boolean soapOnly;
    private boolean idGenerated;
    private String statString;
    private String dataSourceBeanId = "datasource bean id attribute cannot be used";
    boolean createTable = true;

    public StatisticsJDBCInterceptor() {
        this.name = "jdbc logging";
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void init() {
        super.init();
        if (!Objects.equals(this.dataSourceBeanId, DATASOURCE_BEAN_ID_ATTRIBUTE_CANNOT_BE_USED)) {
            this.dataSource = (DataSource)this.applicationContext.getBean(this.dataSourceBeanId, DataSource.class);
        }
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            this.idGenerated = JDBCUtil.isIdGenerated(con.getMetaData());
            this.statString = JDBCUtil.getPreparedInsertStatement(this.idGenerated);
            this.logDatabaseMetaData(con.getMetaData());
            if (this.createTable) {
                this.createTableIfNecessary(con);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Init for StatisticsJDBCInterceptor failed: " + e.getMessage());
        }
        finally {
            this.closeConnection(con);
        }
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        try (Connection con = this.dataSource.getConnection();){
            this.saveExchange(con, exc);
        }
        catch (Exception e) {
            log.warn("Could not save statistics: {}", (Object)e.getMessage());
        }
        return Outcome.CONTINUE;
    }

    private void saveExchange(Connection con, Exchange exc) throws Exception {
        if (this.ignoreGetMethod(exc)) {
            return;
        }
        if (this.ignoreNotSoap(exc)) {
            return;
        }
        PreparedStatement stat = con.prepareStatement(this.statString);
        JDBCUtil.setData(exc, stat, this.idGenerated);
        stat.executeUpdate();
    }

    private boolean ignoreNotSoap(Exchange exc) {
        ContentType ct;
        try {
            ct = exc.getRequest().getHeader().getContentTypeObject();
        }
        catch (ParseException e) {
            return false;
        }
        return this.soapOnly && ct != null && !ct.getBaseType().equalsIgnoreCase("application/soap+xml") && !ct.getBaseType().equalsIgnoreCase("text/xml");
    }

    private boolean ignoreGetMethod(Exchange exc) {
        return this.postMethodOnly && !"POST".equals(exc.getRequest().getMethod());
    }

    private void createTableIfNecessary(Connection con) throws Exception {
        if (JDBCUtil.tableExists(con, "statistic")) {
            return;
        }
        Statement st = con.createStatement();
        try {
            if (JDBCUtil.isOracleDatabase(con.getMetaData())) {
                st.execute(JDBCUtil.getCreateTableStatementForOracle());
                st.execute("CREATE SEQUENCE stat_seq");
                st.execute("CREATE TRIGGER stat_seq_trigger BEFORE INSERT ON statistic FOR EACH ROW BEGIN IF (:new.id IS NULL) THEN SELECT stat_seq.nextval INTO :new.id FROM DUAL; END IF; END; ");
            } else if (JDBCUtil.isMySQLDatabase(con.getMetaData())) {
                st.execute(JDBCUtil.getCreateTableStatementForMySQL());
            } else if (JDBCUtil.isDerbyDatabase(con.getMetaData())) {
                st.execute(JDBCUtil.getCreateTableStatementForDerby());
            } else {
                st.execute(JDBCUtil.getCreateTableStatementForOther());
            }
        }
        finally {
            this.closeConnection(st);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @MCAttribute
    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.dataSourceBeanId = DATASOURCE_BEAN_ID_ATTRIBUTE_CANNOT_BE_USED;
    }

    public boolean isPostMethodOnly() {
        return this.postMethodOnly;
    }

    @MCAttribute
    public void setPostMethodOnly(boolean postMethodOnly) {
        this.postMethodOnly = postMethodOnly;
    }

    public boolean isCreateTable() {
        return this.createTable;
    }

    @MCAttribute
    public void setCreateTable(boolean createTable) {
        this.createTable = createTable;
    }

    public boolean isSoapOnly() {
        return this.soapOnly;
    }

    @MCAttribute
    public void setSoapOnly(boolean soapOnly) {
        this.soapOnly = soapOnly;
    }

    public String getDataSourceBeanId() {
        return this.dataSourceBeanId;
    }

    @Deprecated
    public void setDataSourceBeanId(String dataSourceBeanId) {
        this.dataSourceBeanId = dataSourceBeanId;
    }

    private void logDatabaseMetaData(DatabaseMetaData metaData) throws Exception {
        log.debug("Database metadata:");
        log.debug("Name: {}", (Object)metaData.getDatabaseProductName());
        log.debug("Version: {}", (Object)metaData.getDatabaseProductVersion());
        log.debug("idGenerated: {}", (Object)this.idGenerated);
        log.debug("statString: {}", (Object)this.statString);
    }

    private void closeConnection(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e) {
            log.warn("Could not close JDBC connection", (Throwable)e);
        }
    }

    private void closeConnection(Statement con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e) {
            log.warn("Could not close Statement", (Throwable)e);
        }
    }
}

