/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.templating;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.templating.TemplateInterceptor;
import com.predic8.membrane.core.util.ConfigurationException;
import groovy.text.TemplateExecutionException;

@MCElement(name="soapBody", mixed=true)
public class SoapBodyTemplateInterceptor
extends TemplateInterceptor {
    private SoapVersion version = SoapVersion.SOAP_11;
    private static final String SOAP11_PREFIX = "<s11:Envelope xmlns:s11=\"http://schemas.xmlsoap.org/soap/envelope/\">\n    <s11:Body>\n";
    private static final String SOAP11_POSTFIX = "    </s11:Body>\n</s11:Envelope>\n";
    private static final String SOAP12_PREFIX = "<s12:Envelope xmlns:s12=\"http://www.w3.org/2003/05/soap-envelope\">\n    <s12:Body>\n";
    private static final String SOAP12_POSTFIX = "    </s12:Body>\n</s12:Envelope>\n";

    @Override
    protected String fillTemplate(Exchange exc, Message msg, Interceptor.Flow flow) throws TemplateExecutionException {
        return switch (this.version.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> SOAP11_PREFIX + super.fillTemplate(exc, msg, flow) + SOAP11_POSTFIX;
            case 1 -> SOAP12_PREFIX + super.fillTemplate(exc, msg, flow) + SOAP12_POSTFIX;
        };
    }

    @Override
    public String getContentType() {
        return switch (this.version.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "text/xml";
            case 1 -> "application/soap+xml";
        };
    }

    public String getVersion() {
        return this.version.toString();
    }

    @MCAttribute
    public void setVersion(String version) {
        this.version = switch (version) {
            case "1.1", "11" -> SoapVersion.SOAP_11;
            case "1.2", "12" -> SoapVersion.SOAP_12;
            default -> throw new ConfigurationException("SOAP version %s is not supported by soapBody.".formatted(version));
        };
    }

    public static enum SoapVersion {
        SOAP_11("1.1"),
        SOAP_12("1.2");

        private final String value;

        private SoapVersion(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

