/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.templating;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.core.beautifier.JSONBeautifier;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.TextUtil;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="static", mixed=true)
public class StaticInterceptor
extends AbstractInterceptor {
    protected String location;
    protected String textTemplate;
    protected String contentType = "text/plain";
    protected Boolean pretty = false;
    protected final JSONBeautifier jsonBeautifier = new JSONBeautifier();
    protected static final Logger log = LoggerFactory.getLogger(StaticInterceptor.class);

    public StaticInterceptor() {
        this.name = "static";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleInternal(exc.getRequest(), exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleInternal(exc.getResponse(), exc, Interceptor.Flow.RESPONSE);
    }

    protected Outcome handleInternal(Message msg, Exchange exchange, Interceptor.Flow flow) {
        msg.setBodyContent(this.getTemplateBytes());
        msg.getHeader().setContentType(this.getContentType());
        return Outcome.CONTINUE;
    }

    private byte @NotNull [] getTemplateBytes() {
        if (!this.pretty.booleanValue()) {
            return this.textTemplate.getBytes(StandardCharsets.UTF_8);
        }
        return switch (this.contentType) {
            case "application/json" -> this.prettifyJson(this.textTemplate).getBytes(StandardCharsets.UTF_8);
            case "application/xml", "application/soap+xml", "text/html", "text/xml", "text/html;charset=UTF-8", "text/xml;charset=UTF-8" -> this.prettifyXML(this.textTemplate).getBytes(StandardCharsets.UTF_8);
            default -> TextUtil.unifyIndent(this.textTemplate).getBytes(StandardCharsets.UTF_8);
        };
    }

    private String prettifyXML(String text) {
        try {
            return TextUtil.formatXML(new StringReader(text));
        }
        catch (Exception e) {
            log.warn("Failed to format XML", (Throwable)e);
            return text;
        }
    }

    String prettifyJson(String text) {
        try {
            return this.jsonBeautifier.beautify(text);
        }
        catch (IOException e) {
            log.warn("Failed to format JSON: {}", (Object)e.getMessage());
            return text;
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.getLocation() != null && this.getTextTemplate() != null && !this.getTextTemplate().isBlank()) {
            throw new IllegalStateException("On <" + this.getName() + ">, ./text() and ./@location cannot be set at the same time.");
        }
    }

    public String getLocation() {
        return this.location;
    }

    @MCAttribute
    public void setLocation(String location) {
        this.location = location;
    }

    public String getTextTemplate() {
        return this.textTemplate;
    }

    @MCTextContent
    public void setTextTemplate(String textTemplate) {
        this.textTemplate = textTemplate;
    }

    protected String getName() {
        return this.getClass().getAnnotation(MCElement.class).name();
    }

    public String getContentType() {
        return this.contentType;
    }

    @MCAttribute
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Boolean getPretty() {
        return this.pretty;
    }

    @MCAttribute
    public void setPretty(String pretty) {
        this.pretty = Boolean.valueOf(pretty);
    }

    private String formatAsHtml(String plaintext) {
        return String.join((CharSequence)"<br />", StringEscapeUtils.escapeHtml4((String)plaintext).split("\n"));
    }

    @Override
    public String getShortDescription() {
        Object s = "Pretty print: %s<br/>".formatted(this.pretty);
        if (this.contentType != null) {
            s = (String)s + "Content-Type: %s<br/>".formatted(this.contentType);
        }
        return (String)s + this.formatAsHtml(this.textTemplate);
    }
}

