/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.templating;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.MimeType;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.templating.StaticInterceptor;
import com.predic8.membrane.core.lang.ScriptingUtils;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.util.ConfigurationException;
import groovy.lang.GroovyRuntimeException;
import groovy.text.StreamingTemplateEngine;
import groovy.text.Template;
import groovy.text.TemplateExecutionException;
import groovy.text.XmlTemplateEngine;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

@MCElement(name="template", mixed=true)
public class TemplateInterceptor
extends StaticInterceptor {
    private boolean scriptAccessesJson;
    protected Template template;

    public TemplateInterceptor() {
        this.name = "template";
    }

    @Override
    protected Outcome handleInternal(Message msg, Exchange exc, Interceptor.Flow flow) {
        try {
            msg.setBodyContent(this.fillAndGetBytes(exc, msg, flow));
        }
        catch (TemplateExecutionException e) {
            log.warn("Groovy template error: {}", (Object)e.getMessage());
            ProblemDetails.gateway(this.router.isProduction(), this.getDisplayName()).addSubSee("template").detail("Error during template rendering.").internal("line", e.getLineNumber()).exception(e).stacktrace(false).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        catch (GroovyRuntimeException e) {
            log.warn("Groovy error executing template: {}", (Object)e.getMessage());
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).addSubSee("groovy").detail("Groovy error during template rendering.").exception(e).stacktrace(false).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).addSubSee("template").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        msg.getHeader().setContentType(this.getContentType());
        return Outcome.CONTINUE;
    }

    protected String fillTemplate(Exchange exc, Message msg, Interceptor.Flow flow) throws TemplateExecutionException {
        String payload = this.template.make(this.getVariableBinding(exc, msg, flow)).toString();
        if (MimeType.isOfMediaType("application/json", this.contentType) && this.pretty.booleanValue()) {
            return this.prettifyJson(payload);
        }
        return payload;
    }

    @NotNull
    private HashMap<String, Object> getVariableBinding(Exchange exc, Message msg, Interceptor.Flow flow) {
        return ScriptingUtils.createParameterBindings(this.router, exc, flow, this.scriptAccessesJson && msg.isJSON());
    }

    private byte[] fillAndGetBytes(Exchange exc, Message msg, Interceptor.Flow flow) throws TemplateExecutionException {
        return this.fillTemplate(exc, msg, flow).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void init() {
        super.init();
        if (this.getLocation() != null && this.getTextTemplate() != null && !this.getTextTemplate().isBlank()) {
            throw new IllegalStateException("On <" + this.getName() + ">, ./text() and ./@location cannot be set at the same time.");
        }
        if (this.location != null) {
            this.scriptAccessesJson = true;
            try (InputStreamReader reader = new InputStreamReader(this.getRouter().getResolverMap().resolve(ResolverMap.combine(this.router.getBaseLocation(), this.location)));){
                if (FilenameUtils.getExtension((String)this.getLocation()).equals("xml")) {
                    this.template = new XmlTemplateEngine().createTemplate((Reader)reader);
                    this.setContentType("application/xml");
                } else {
                    this.template = new StreamingTemplateEngine().createTemplate((Reader)reader);
                }
                return;
            }
            catch (Exception e) {
                throw new ConfigurationException("Could not create template from " + this.location, e);
            }
        }
        if (!this.textTemplate.isBlank()) {
            this.scriptAccessesJson = this.textTemplate.contains("json");
            try {
                this.template = new StreamingTemplateEngine().createTemplate(this.getTextTemplate());
            }
            catch (Exception e) {
                throw new ConfigurationException("Could not create template from " + this.textTemplate, e);
            }
            return;
        }
        throw new IllegalStateException("You have to set either ./@location or ./text()");
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }
}

