/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.testservice;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.Path;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.WSDLInterceptor;
import com.predic8.membrane.core.proxies.AbstractServiceProxy;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.HttpUtil;
import com.predic8.membrane.core.util.SOAPUtil;
import com.predic8.membrane.core.util.URLUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

@MCElement(name="testService")
public class TestServiceInterceptor
extends AbstractInterceptor {
    private static final String SOAP_VERSION = "soap_version";
    private static final Pattern WSDL = Pattern.compile("\\?WSDL", 2);
    private static final Pattern RELATIVE_PATH_PATTERN = Pattern.compile("^./[^/?]*\\?");
    private static final Logger log = LoggerFactory.getLogger(TestServiceInterceptor.class);
    private final WSDLInterceptor wi = new WSDLInterceptor();

    public TestServiceInterceptor() {
        this.name = "Test SOAP Service (Legacy)";
    }

    @Override
    public String getShortDescription() {
        return "Provides a SOAP service for testing or demonstration purposes. (Deprecated, use Sample Soap Service plugin instead.)";
    }

    @Override
    public void init() {
        Path path;
        super.init();
        this.wi.init(this.router);
        Proxy r = this.router.getParentProxy(this);
        if (r instanceof AbstractServiceProxy && (path = ((AbstractServiceProxy)r).getPath()) != null) {
            if (path.isRegExp()) {
                throw new ConfigurationException("<testService> may not be used together with <path isRegExp=\"true\">.");
            }
            String keyPath = path.getValue();
            String name = TestServiceInterceptor.getName(this.router, keyPath);
            this.wi.setPathRewriter(path2 -> {
                try {
                    if (path2.contains("://")) {
                        path2 = new URL(new URL(path2), keyPath).toString();
                    } else {
                        Matcher m = RELATIVE_PATH_PATTERN.matcher(path2);
                        path2 = m.replaceAll("./" + name + "?");
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return path2;
            });
        }
    }

    @NotNull
    private static String getName(Router router, String keyPath) {
        try {
            return URLUtil.getName(router.getUriFactory(), keyPath);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Could not get name from " + keyPath, e);
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        if (WSDL.matcher(exc.getRequest().getUri()).find()) {
            exc.setResponse(Response.ok().header("Server", "Membrane API Gateway").header("Content-Type", "text/xml").body(this.getClass().getResourceAsStream("the.wsdl"), true).build());
            this.wi.handleResponse(exc);
            return Outcome.RETURN;
        }
        try {
            Document d = TestServiceInterceptor.getDocument(exc);
            exc.setResponse(this.createResponse(exc, d));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            exc.setResponse(this.createResponse(e, exc.getProperty(SOAP_VERSION) == null));
        }
        return Outcome.RETURN;
    }

    private static Document getDocument(Exchange exc) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(exc.getRequest().getBodyAsStreamDecoded());
    }

    private Response createResponse(Throwable e, boolean useSoap11) {
        String title = "Internal Server Error";
        String message = e.getMessage();
        String body = useSoap11 ? SOAPUtil.createSOAPFaultResponse(SOAPUtil.FaultCode.Server, title, Map.of("details", message)).getBodyAsStringDecoded() : SOAPUtil.getFaultSOAP12Body(title, message);
        return Response.internalServerError().header("Server", "Membrane API Gateway").header(HttpUtil.createHeaders("text/xml;charset=UTF-8", new String[0])).body(body.getBytes(StandardCharsets.UTF_8)).build();
    }

    private Response createResponse(Exchange exc, Document d) {
        Element envelope = d.getDocumentElement();
        if (envelope == null) {
            throw new AssertionError((Object)"No SOAP <Envelope> found.");
        }
        if (!envelope.getLocalName().equals("Envelope")) {
            throw new AssertionError((Object)"No SOAP Envelope found.");
        }
        if (envelope.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            return this.handleSOAP11(envelope);
        }
        if (envelope.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
            exc.setProperty(SOAP_VERSION, "1.2");
            return this.handleSOAP12(envelope);
        }
        throw new AssertionError((Object)"Unknown SOAP version.");
    }

    private Response handleSOAP11(Element envelope) {
        Node body = null;
        NodeList children = envelope.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i) instanceof Text) {
                String text = children.item(i).getNodeValue();
                for (int j = 0; j < text.length(); ++j) {
                    if (!Character.isWhitespace(text.charAt(j))) {
                        throw new AssertionError((Object)"Found non-whitespace text.");
                    }
                }
                continue;
            }
            Node j = children.item(i);
            if (!(j instanceof Element)) {
                throw new AssertionError((Object)("Non-element child of <Envelope> found: " + children.item(i).getNodeName() + "."));
            }
            Element item = (Element)j;
            if (!item.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                throw new AssertionError((Object)"Non-SOAP child element of <Envelope> found.");
            }
            if (!item.getLocalName().equals("Body")) continue;
            body = item;
        }
        if (body == null) {
            throw new AssertionError((Object)"No SOAP <Body> found.");
        }
        children = body.getChildNodes();
        Element operation = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i) instanceof Text) {
                String text = children.item(i).getNodeValue();
                for (int j = 0; j < text.length(); ++j) {
                    if (!Character.isWhitespace(text.charAt(j))) {
                        throw new AssertionError((Object)"Found non-whitespace text.");
                    }
                }
                continue;
            }
            if (!(children.item(i) instanceof Element)) {
                throw new AssertionError((Object)("Non-element child of <Body> found: " + children.item(i).getNodeName() + "."));
            }
            operation = (Element)children.item(i);
        }
        if (operation == null) {
            throw new AssertionError((Object)"No SOAP <Body> found.");
        }
        return this.handleOperation(operation, true);
    }

    private Response handleSOAP12(Element envelope) {
        Node body = null;
        NodeList children = envelope.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i) instanceof Text) {
                String text = children.item(i).getNodeValue();
                for (int j = 0; j < text.length(); ++j) {
                    if (!Character.isWhitespace(text.charAt(j))) {
                        throw new AssertionError((Object)"Found non-whitespace text.");
                    }
                }
                continue;
            }
            Node j = children.item(i);
            if (!(j instanceof Element)) {
                throw new AssertionError((Object)("Non-element child of <Envelope> found: " + children.item(i).getNodeName() + "."));
            }
            Element item = (Element)j;
            if (!item.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
                throw new AssertionError((Object)"Non-SOAP child element of <Envelope> found.");
            }
            if (!item.getLocalName().equals("Body")) continue;
            body = item;
        }
        if (body == null) {
            throw new AssertionError((Object)"No SOAP <Body> found.");
        }
        children = body.getChildNodes();
        Element operation = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i) instanceof Text) {
                String text = children.item(i).getNodeValue();
                for (int j = 0; j < text.length(); ++j) {
                    if (!Character.isWhitespace(text.charAt(j))) {
                        throw new AssertionError((Object)"Found non-whitespace text.");
                    }
                }
                continue;
            }
            if (!(children.item(i) instanceof Element)) {
                throw new AssertionError((Object)("Non-element child of <Body> found: " + children.item(i).getNodeName() + "."));
            }
            operation = (Element)children.item(i);
        }
        if (operation == null) {
            throw new AssertionError((Object)"No SOAP <Body> found.");
        }
        return this.handleOperation(operation, false);
    }

    private Response handleOperation(Element operation, boolean soap11) {
        if (!operation.getNamespaceURI().equals("http://thomas-bayer.com/blz/")) {
            throw new AssertionError((Object)"Unknown operation namespace.");
        }
        if (operation.getLocalName().equals("getBank")) {
            NodeList children = operation.getChildNodes();
            Node param = null;
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i) instanceof Text) {
                    String text = children.item(i).getNodeValue();
                    for (int j = 0; j < text.length(); ++j) {
                        if (!Character.isWhitespace(text.charAt(j))) {
                            throw new AssertionError((Object)"Found non-whitespace text.");
                        }
                    }
                    continue;
                }
                if (!(children.item(i) instanceof Element)) {
                    throw new AssertionError((Object)("Non-element child of <Body> found: " + children.item(i).getNodeName() + "."));
                }
                param = (Element)children.item(i);
            }
            if (param == null) {
                throw new AssertionError((Object)"No parameter child of operation element found.");
            }
            if (!param.getNamespaceURI().equals("http://thomas-bayer.com/blz/") || !param.getLocalName().equals("blz")) {
                throw new AssertionError((Object)"Unknown parameter element.");
            }
            children = param.getChildNodes();
            if (children.getLength() != 1) {
                throw new AssertionError((Object)"Parameter element has children.length != 1");
            }
            Node node = children.item(0);
            if (!(node instanceof Text)) {
                throw new AssertionError((Object)"Parameter element has non-text child.");
            }
            Text text = (Text)node;
            return this.getBank(text.getNodeValue(), soap11);
        }
        throw new AssertionError((Object)"Unknown operation.");
    }

    private Response getBank(String blz, boolean soap11) {
        if (blz.equals("38060186")) {
            return this.respondBank("Volksbank Bonn Rhein-Sieg", "GENODED1BRS", "Bonn", "53015", soap11);
        }
        throw new AssertionError((Object)"Keine Bank gefunden.");
    }

    private String escape(String s) {
        return s.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
    }

    private Response respondBank(String bezeichnung, String bic, String ort, String plz, boolean soap11) {
        String ns = soap11 ? "http://schemas.xmlsoap.org/soap/envelope/" : "http://www.w3.org/2003/05/soap-envelope";
        String body = "<soapenv:Envelope xmlns:soapenv=\"" + ns + "\"><soapenv:Body><ns1:getBankResponse xmlns:ns1=\"http://thomas-bayer.com/blz/\"><ns1:details><ns1:bezeichnung>" + this.escape(bezeichnung) + "</ns1:bezeichnung><ns1:bic>" + this.escape(bic) + "</ns1:bic><ns1:ort>" + this.escape(ort) + "</ns1:ort><ns1:plz>" + this.escape(plz) + "</ns1:plz></ns1:details></ns1:getBankResponse></soapenv:Body></soapenv:Envelope>";
        return Response.ok().header("Server", "Membrane API Gateway").header("Content-Type", "text/xml;charset=UTF-8").body(body.getBytes(StandardCharsets.UTF_8)).build();
    }
}

