/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.tunnel;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.transport.ws.WebSocketInterceptorInterface;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.URLUtil;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="webSocket")
public class WebSocketInterceptor
extends AbstractInterceptor {
    protected static final Logger log = LoggerFactory.getLogger(WebSocketInterceptor.class);
    private String url;
    private String pathQuery;
    private List<WebSocketInterceptorInterface> interceptors = new ArrayList<WebSocketInterceptorInterface>();

    @Override
    public void init() {
        super.init();
        try {
            this.pathQuery = this.url == null ? null : URLUtil.getPathQuery(this.getRouter().getUriFactory(), this.url);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Could not parse " + this.url, e);
        }
    }

    @Override
    public String getDisplayName() {
        return "websocket";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        if ("websocket".equalsIgnoreCase(exc.getRequest().getHeader().getFirstValue("Upgrade"))) {
            exc.setProperty("membrane.use.websocket", Boolean.TRUE);
            if (this.url != null) {
                exc.getRequest().setUri(this.pathQuery);
                exc.getDestinations().set(0, this.url);
            }
        }
        return Outcome.CONTINUE;
    }

    @Override
    public String getShortDescription() {
        return "Allow HTTP protocol upgrades to the <a href=\"http://tools.ietf.org/html/rfc6455\">WebSocket protocol</a>. After the upgrade, the connection's data packets are simply forwarded and not inspected.";
    }

    public String getUrl() {
        return this.url;
    }

    @MCAttribute
    public void setUrl(String url) {
        this.url = url;
    }

    public List<WebSocketInterceptorInterface> getInterceptors() {
        return this.interceptors;
    }

    @MCChildElement
    public void setInterceptors(List<WebSocketInterceptorInterface> interceptors) {
        this.interceptors = interceptors;
    }
}

