/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.ws_addressing;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.ws_addressing.DecoupledEndpointRegistry;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class WsaEndpointRewriter {
    private static final String ADDRESSING_URI_2005_08 = "http://www.w3.org/2005/08/addressing";
    private static final String ADDRESSING_URI_2004_08 = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private final DecoupledEndpointRegistry registry;

    public WsaEndpointRewriter(DecoupledEndpointRegistry registry) {
        this.registry = registry;
    }

    public void rewriteEndpoint(InputStream reader, OutputStream writer, int port, Exchange exc) throws XMLStreamException {
        XMLEventReader parser = this.inputFactory.createXMLEventReader(reader);
        XMLEventWriter eventWriter = XMLOutputFactory.newInstance().createXMLEventWriter(writer);
        String id = null;
        String url = null;
        block0: while (parser.hasNext()) {
            XMLEvent e = parser.nextEvent();
            if (e.isStartElement()) {
                if (this.isReplyTo(e.asStartElement())) {
                    while (e.isStartElement() || !this.isReplyTo(e.asEndElement())) {
                        if (e.isStartElement() && this.isAddress(e.asStartElement())) {
                            url = parser.getElementText();
                            this.addRewrittenAddressElement(eventWriter, url, port, e.asStartElement());
                            continue block0;
                        }
                        eventWriter.add(e);
                        e = parser.nextTag();
                    }
                }
                if (this.isMessageId(e.asStartElement())) {
                    id = parser.getElementText();
                    exc.setProperty("messageId", id);
                    this.addMessageIdElement(eventWriter, id, e.asStartElement());
                    continue;
                }
            }
            eventWriter.add(e);
        }
        this.registry.register(id, url);
    }

    private void addMessageIdElement(XMLEventWriter writer, String id, StartElement startElement) throws XMLStreamException {
        writer.add(this.eventFactory.createStartElement("", startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart(), startElement.getAttributes(), startElement.getNamespaces(), startElement.getNamespaceContext()));
        writer.add(this.eventFactory.createCharacters(id));
        writer.add(this.eventFactory.createEndElement("", startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart(), startElement.getNamespaces()));
    }

    private boolean isMessageId(StartElement startElement) {
        return startElement.getName().equals(new QName(ADDRESSING_URI_2005_08, "MessageID")) || startElement.getName().equals(new QName(ADDRESSING_URI_2004_08, "MessageID"));
    }

    private void addRewrittenAddressElement(XMLEventWriter writer, String address, int port, StartElement startElement) throws XMLStreamException {
        writer.add(this.eventFactory.createStartElement("", startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart(), startElement.getAttributes(), startElement.getNamespaces(), startElement.getNamespaceContext()));
        writer.add(this.eventFactory.createCharacters(address.replaceFirst(":\\d+/", ":" + port + "/")));
        writer.add(this.eventFactory.createEndElement("", startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart(), startElement.getNamespaces()));
    }

    private boolean isReplyTo(StartElement startElement) {
        return startElement.getName().equals(new QName(ADDRESSING_URI_2005_08, "ReplyTo"));
    }

    private boolean isReplyTo(EndElement endElement) {
        return endElement.getName().equals(new QName(ADDRESSING_URI_2005_08, "ReplyTo"));
    }

    private boolean isAddress(StartElement startElement) {
        return startElement.getName().equals(new QName(ADDRESSING_URI_2005_08, "Address"));
    }
}

