/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.ws_addressing;

import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.ws_addressing.DecoupledEndpointRegistry;
import com.predic8.membrane.core.interceptor.ws_addressing.WsaEndpointRewriter;
import java.io.ByteArrayOutputStream;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class WsaEndpointRewriterInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WsaEndpointRewriterInterceptor.class);

    @Override
    public Outcome handleRequest(Exchange exc) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            new WsaEndpointRewriter(this.getRegistry()).rewriteEndpoint(exc.getRequest().getBodyAsStreamDecoded(), output, 2020, exc);
        }
        catch (XMLStreamException e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Could not rewrite endpoint!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        exc.getRequest().setBodyContent(output.toByteArray());
        return Outcome.CONTINUE;
    }

    private DecoupledEndpointRegistry getRegistry() {
        ApplicationContext beanFactory = this.getRouter().getBeanFactory();
        if (beanFactory == null) {
            return new DecoupledEndpointRegistry();
        }
        return (DecoupledEndpointRegistry)beanFactory.getBean(DecoupledEndpointRegistry.class);
    }
}

