/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xml;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.StringUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="json2Xml")
public class Json2XmlInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(Json2XmlInterceptor.class);
    private static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private String root;

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.RESPONSE);
    }

    private Outcome handleInternal(Exchange exchange, Interceptor.Flow flow) {
        Message msg = exchange.getMessage(flow);
        if (!msg.isJSON()) {
            return Outcome.CONTINUE;
        }
        try {
            msg.setBodyContent(this.json2Xml(msg.getBodyAsStream()));
        }
        catch (JSONException e) {
            log.info("Error parsing JSON: {}", (Object)e.getMessage());
            ProblemDetails.user(this.router.isProduction(), this.getDisplayName()).title("Error parsing JSON").addSubType("validation/json").exception(e).stacktrace(false).internal("flow", (Object)flow).internal("body", StringUtil.truncateAfter(msg.getBodyAsStringDecoded(), 200)).buildAndSetResponse(exchange);
            return Outcome.ABORT;
        }
        catch (Exception e) {
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).title("Error parsing JSON").addSubType("validation/json").exception(e).stacktrace(true).internal("flow", (Object)flow).internal("body", StringUtil.truncateAfter(msg.getBodyAsStringDecoded(), 200)).buildAndSetResponse(exchange);
            return Outcome.ABORT;
        }
        msg.getHeader().setContentType("application/xml");
        return Outcome.CONTINUE;
    }

    private byte[] json2Xml(InputStream body) {
        return (PROLOG + XML.toString((Object)this.getJSONRoot(body))).getBytes(StandardCharsets.UTF_8);
    }

    @NotNull
    private JSONObject getJSONRoot(InputStream body) {
        if (this.root != null) {
            return this.createRoot(this.root, this.convertToJsonObject(body));
        }
        JSONObject json = this.convertToJsonObject(body);
        if (json.length() == 1) {
            return json;
        }
        return this.createRoot("root", json);
    }

    private JSONObject createRoot(String name, JSONObject jsonObject) {
        JSONObject root = new JSONObject();
        root.put(name, (Object)jsonObject);
        return root;
    }

    private JSONObject convertToJsonObject(InputStream body) {
        return new JSONObject(new JSONTokener((Reader)new InputStreamReader(body, StandardCharsets.UTF_8)));
    }

    @Override
    public String getDisplayName() {
        return "json 2 xml";
    }

    @Override
    public String getShortDescription() {
        return "Converts JSON message bodies to XML.";
    }

    public String getRoot() {
        return this.root;
    }

    @MCAttribute
    public void setRoot(String root) {
        this.root = root;
    }
}

