/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xmlcontentfilter;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.xmlcontentfilter.XMLContentFilter;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="soapStackTraceFilter")
public class SOAPStackTraceFilterInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(SOAPStackTraceFilterInterceptor.class);
    private static final String XPATH = "//*[local-name()='Fault' and namespace-uri()='%s']//*[local-name()='stackTrace' or local-name()='stacktrace'] |\n//*[local-name()='Fault' and namespace-uri()='%s']//*[local-name()='faultstring' and contains(., '.java:')] |\n//*[local-name()='Fault' and namespace-uri()='%s']//*[local-name()='exception' and namespace-uri()='http://jax-ws.dev.java.net/']/message |\n//*[local-name()='Fault' and namespace-uri()='%s']//detail/Exception\n".formatted("http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/soap/envelope/");
    private final XMLContentFilter xmlContentFilter = new XMLContentFilter(XPATH);

    public SOAPStackTraceFilterInterceptor() throws XPathExpressionException {
        this.setDisplayName("soap stacktrace filter");
        this.setFlow(Interceptor.Flow.Set.REQUEST_RESPONSE_ABORT_FLOW);
    }

    @Override
    public String getShortDescription() {
        return "Removes SOAP stacktraces from envelopes.";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleMessage(exc, exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleMessage(exc, exc.getResponse());
    }

    private Outcome handleMessage(Exchange exc, Message message) {
        try {
            this.xmlContentFilter.removeMatchingElements(message);
            return Outcome.CONTINUE;
        }
        catch (Exception e) {
            LOG.error("soapStackTraceFilter error", (Throwable)e);
            exc.setResponse(Response.internalServerError("soapStackTraceFilter error. See log for details.").build());
            return Outcome.ABORT;
        }
    }
}

