/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xmlcontentfilter;

import com.predic8.membrane.core.interceptor.xmlcontentfilter.SimpleXPathParser;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class SimpleXPathAnalyzer {
    public List<SimpleXPathParser.ContainerNode> getIntersectExceptExprs(String xpath) {
        SimpleXPathParser.ContainerNode node = new SimpleXPathParser().parse(xpath);
        if (!this.isUnionExpr(node)) {
            return null;
        }
        return this.splitUnionExprIntoIntersectExceptExprs(node);
    }

    public QName getElement(SimpleXPathParser.ContainerNode intersectExceptExpr) {
        for (String op : new String[]{"intersect", "except", "instance", "treat", "castable", "cast", "+", "-"}) {
            for (SimpleXPathParser.Node n : intersectExceptExpr.nodes) {
                if (!(n instanceof SimpleXPathParser.UnparsedStringNode) || this.indexOfOperand(((SimpleXPathParser.UnparsedStringNode)n).s, op) == -1) continue;
                return null;
            }
        }
        if (intersectExceptExpr.nodes.length == 0) {
            return null;
        }
        if (!(intersectExceptExpr.nodes[0] instanceof SimpleXPathParser.UnparsedStringNode)) {
            return null;
        }
        Marker m = new Marker(((SimpleXPathParser.UnparsedStringNode)intersectExceptExpr.nodes[0]).s);
        this.skipWhitespace(m);
        if (this.eatChar(m) != 47) {
            return null;
        }
        if (this.eatChar(m) != 47) {
            return null;
        }
        this.skipWhitespace(m);
        String elementName = this.getName(m);
        if (elementName == null) {
            if (m.s.codePointAt(m.p) != 42) {
                return null;
            }
            elementName = "*";
            ++m.p;
        }
        if (elementName.contains(":")) {
            throw new RuntimeException("Namespace prefixes are not allowed in XPath expressions here, since they are not declared. Use '//*[local-name()='foo' and namespace-uri()='http://bar.com/'] instead");
        }
        this.skipWhitespace(m);
        if (m.isAtEnd() && intersectExceptExpr.nodes.length > 1 && intersectExceptExpr.nodes[1] instanceof SimpleXPathParser.SquareBracketNode) {
            String string1;
            Marker m2;
            SimpleXPathParser.ContainerNode predicate = ((SimpleXPathParser.SquareBracketNode)intersectExceptExpr.nodes[1]).node;
            if (predicate.nodes.length == 4 && predicate.nodes[0] instanceof SimpleXPathParser.UnparsedStringNode && predicate.nodes[1] instanceof SimpleXPathParser.RoundBracketNode && ((SimpleXPathParser.RoundBracketNode)predicate.nodes[1]).node.nodes.length == 0 && predicate.nodes[2] instanceof SimpleXPathParser.UnparsedStringNode && predicate.nodes[3] instanceof SimpleXPathParser.StringNode) {
                m2 = new Marker(((SimpleXPathParser.UnparsedStringNode)predicate.nodes[0]).s);
                string1 = ((SimpleXPathParser.StringNode)predicate.nodes[3]).s;
                this.skipWhitespace(m2);
                String function = this.getName(m2);
                if (m2.isAtEnd()) {
                    if ("namespace-uri".equals(function)) {
                        return new QName(string1, elementName);
                    }
                    if ("local-name".equals(function) && elementName.equals("*")) {
                        return new QName(string1);
                    }
                }
            }
            if ("*".equals(elementName) && predicate.nodes.length == 8 && predicate.nodes[0] instanceof SimpleXPathParser.UnparsedStringNode && predicate.nodes[1] instanceof SimpleXPathParser.RoundBracketNode && ((SimpleXPathParser.RoundBracketNode)predicate.nodes[1]).node.nodes.length == 0 && predicate.nodes[2] instanceof SimpleXPathParser.UnparsedStringNode && predicate.nodes[3] instanceof SimpleXPathParser.StringNode && predicate.nodes[4] instanceof SimpleXPathParser.UnparsedStringNode && predicate.nodes[5] instanceof SimpleXPathParser.RoundBracketNode && ((SimpleXPathParser.RoundBracketNode)predicate.nodes[5]).node.nodes.length == 0 && predicate.nodes[6] instanceof SimpleXPathParser.UnparsedStringNode && predicate.nodes[7] instanceof SimpleXPathParser.StringNode) {
                m2 = new Marker(((SimpleXPathParser.UnparsedStringNode)predicate.nodes[0]).s);
                string1 = ((SimpleXPathParser.StringNode)predicate.nodes[3]).s;
                this.skipWhitespace(m2);
                String function = this.getName(m2);
                if (m2.isAtEnd() && "local-name".equals(function)) {
                    Marker m3 = new Marker(((SimpleXPathParser.UnparsedStringNode)predicate.nodes[4]).s);
                    String string2 = ((SimpleXPathParser.StringNode)predicate.nodes[7]).s;
                    this.skipWhitespace(m3);
                    String and = this.getName(m3);
                    if ("and".equals(and)) {
                        this.skipWhitespace(m3);
                        String function2 = this.getName(m3);
                        if (m3.isAtEnd() && "namespace-uri".equals(function2)) {
                            return new QName(string2, string1);
                        }
                    }
                }
            }
        }
        return "*".equals(elementName) ? null : new QName(elementName);
    }

    private String getName(Marker m) {
        StringBuilder sb;
        block1: {
            int c;
            sb = new StringBuilder();
            while (this.isNameChar(c = this.eatChar(m))) {
                sb.appendCodePoint(c);
            }
            if (c == 0) break block1;
            --m.p;
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private int eatChar(Marker m) {
        return m.p == m.s.length() ? 0 : m.s.codePointAt(m.p++);
    }

    private void skipWhitespace(Marker m) {
        while (m.p != m.s.length() && this.isWhiteSpace(m.s.codePointAt(m.p))) {
            ++m.p;
        }
    }

    private boolean isUnionExpr(SimpleXPathParser.ContainerNode node) {
        for (String op : new String[]{",", "return", "for", "some", "every", "if", "or", "and", "eq", "ne", "lt", "le", "gt", "ge", "=", "!=", "<", "<=", ">", ">=", "is", "<<", ">>", "to", "+", "-", "*", "div", "idiv", "mod"}) {
            for (SimpleXPathParser.Node n : node.nodes) {
                if (!(n instanceof SimpleXPathParser.UnparsedStringNode) || this.indexOfOperand(((SimpleXPathParser.UnparsedStringNode)n).s, op) == -1) continue;
                return false;
            }
        }
        return true;
    }

    private List<SimpleXPathParser.ContainerNode> splitUnionExprIntoIntersectExceptExprs(SimpleXPathParser.ContainerNode node) {
        ArrayList<SimpleXPathParser.ContainerNode> res = new ArrayList<SimpleXPathParser.ContainerNode>();
        ArrayList<SimpleXPathParser.Node> intersectExceptExprParts = new ArrayList<SimpleXPathParser.Node>();
        for (SimpleXPathParser.Node n : node.nodes) {
            if (n instanceof SimpleXPathParser.UnparsedStringNode) {
                ArrayList<String> parts = new ArrayList<String>();
                for (String part : this.splitOnOperand(((SimpleXPathParser.UnparsedStringNode)n).s, "|")) {
                    parts.addAll(this.splitOnOperand(part, "union"));
                }
                for (int i = 0; i < parts.size(); ++i) {
                    if (i >= 1) {
                        res.add(new SimpleXPathParser.ContainerNode(intersectExceptExprParts.toArray(new SimpleXPathParser.Node[0])));
                        intersectExceptExprParts = new ArrayList();
                    }
                    intersectExceptExprParts.add(new SimpleXPathParser.UnparsedStringNode((String)parts.get(i)));
                }
                continue;
            }
            intersectExceptExprParts.add(n);
        }
        if (intersectExceptExprParts.size() > 0) {
            res.add(new SimpleXPathParser.ContainerNode(intersectExceptExprParts.toArray(new SimpleXPathParser.Node[0])));
        }
        return res;
    }

    private List<String> splitOnOperand(String xpath, String op) {
        int p = this.indexOfOperand(xpath, op);
        if (p == -1) {
            ArrayList<String> res = new ArrayList<String>();
            res.add(xpath);
            return res;
        }
        List<String> res = this.splitOnOperand(xpath.substring(p + op.length()), op);
        res.add(0, xpath.substring(0, p));
        return res;
    }

    private int indexOfOperand(String xpath, String op) {
        if ("*".equals(op)) {
            int p = -1;
            block0: while (true) {
                if ((p = xpath.indexOf(op, p + 1)) == -1) {
                    return -1;
                }
                int q = p;
                do {
                    if (--q == -1) continue block0;
                } while (this.isWhiteSpace(xpath.codePointAt(q)));
                int c = xpath.codePointAt(q);
                if (c != 43 && c != 45 && c != 47 && c != 58 && c != 64) break;
            }
            return p;
        }
        int p = -1;
        do {
            if ((p = xpath.indexOf(op, p + 1)) != -1) continue;
            return -1;
        } while (this.isNameChar(op.codePointAt(0)) && p > 0 && this.isNameChar(xpath.codePointAt(p - 1)) || this.isNameChar(op.codePointAt(op.length() - 1)) && p + op.length() < xpath.length() && this.isNameChar(xpath.charAt(p + op.length())));
        return p;
    }

    private boolean isNameChar(int c) {
        return c == 58 || c >= 65 && c <= 90 || c == 95 || c >= 97 && c <= 122 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 767 || c >= 880 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039 || c == 45 || c == 46 || c >= 48 && c <= 57 || c == 183 || c >= 768 && c <= 879 || c >= 8255 && c <= 8256;
    }

    private boolean isWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10;
    }

    private static class Marker {
        public final String s;
        public int p;

        public Marker(String s) {
            this.s = s;
            this.p = 0;
        }

        public boolean isAtEnd() {
            return this.p == this.s.length();
        }
    }
}

