/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xmlcontentfilter;

import java.io.PrintStream;
import java.util.ArrayList;

public class SimpleXPathParser {
    public ContainerNode parse(String xpath) {
        return this.parseNormal(new Marker(xpath), -1);
    }

    private ContainerNode parseNormal(Marker m, int terminator) {
        StringBuilder sb2 = new StringBuilder();
        ArrayList<Node> result = new ArrayList<Node>();
        while (true) {
            int c;
            if (m.p == m.s.length()) {
                if (terminator != -1) {
                    throw new RuntimeException("Unbalanced XPath expression");
                }
                break;
            }
            if ((c = m.s.codePointAt(m.p++)) != 39 && c != 34 && c != 40 && c != 91 && c != terminator) {
                sb2.appendCodePoint(c);
                continue;
            }
            if (sb2.length() > 0) {
                result.add(new UnparsedStringNode(sb2.toString()));
                sb2 = new StringBuilder();
            }
            switch (c) {
                case 34: 
                case 39: {
                    result.add(this.parseString(m, c));
                    break;
                }
                case 40: {
                    if (m.p == m.s.length()) {
                        throw new RuntimeException("unbalanced XPath expression.");
                    }
                    if (m.s.codePointAt(m.p) == 58) {
                        result.add(this.parseComment(m));
                        break;
                    }
                    result.add(new RoundBracketNode(this.parseNormal(m, 41)));
                    break;
                }
                case 91: {
                    result.add(new SquareBracketNode(this.parseNormal(m, 93)));
                }
            }
            if (c == terminator) break;
        }
        if (sb2.length() > 0) {
            result.add(new UnparsedStringNode(sb2.toString()));
        }
        return new ContainerNode(result.toArray(new Node[0]));
    }

    private Node parseComment(Marker m) {
        int comment_start = m.p += 2;
        int depth = 1;
        while (m.p < m.s.length()) {
            int c = m.s.codePointAt(m.p++);
            switch (c) {
                case 58: {
                    if (m.p == m.s.length()) {
                        throw new RuntimeException("Unbalanced comment.");
                    }
                    if (m.s.codePointAt(m.p++) != 41 || --depth != 0) break;
                    return new CommentNode(m.s.substring(comment_start, m.p - 1));
                }
                case 40: {
                    if (m.p == m.s.length()) {
                        throw new RuntimeException("Unbalanced comment.");
                    }
                    if (m.s.codePointAt(m.p++) != 58) break;
                    ++depth;
                }
            }
        }
        throw new RuntimeException("Unbalanced comment.");
    }

    private StringNode parseString(Marker m, int terminator) {
        int q;
        StringBuilder sb = new StringBuilder();
        while (true) {
            if ((q = m.s.indexOf(terminator, m.p)) == -1) {
                throw new RuntimeException("Unbalanced string.");
            }
            sb.append(m.s.substring(m.p, q));
            if (q == m.s.length() - 1 || m.s.codePointAt(q + 1) != terminator) break;
            sb.appendCodePoint(terminator);
            m.p = q + 2;
        }
        m.p = q + 1;
        return new StringNode(sb.toString());
    }

    private static class Marker {
        public final String s;
        public int p;

        public Marker(String s) {
            this.s = s;
            this.p = 0;
        }
    }

    public static class ContainerNode
    extends Node {
        protected Node[] nodes;

        public ContainerNode(Node ... nodes) {
            this.nodes = nodes;
        }

        @Override
        public void print(PrintStream ps) {
            ps.print("CONTAINER(");
            for (Node n : this.nodes) {
                n.print(ps);
                ps.print(",");
            }
            ps.print(")");
        }
    }

    public static class UnparsedStringNode
    extends Node {
        protected String s;

        public UnparsedStringNode(String s) {
            this.s = s;
        }

        @Override
        public void print(PrintStream ps) {
            ps.print("UNPARSED(" + this.s + ")");
        }
    }

    public static class StringNode
    extends Node {
        protected String s;

        public StringNode(String s) {
            this.s = s;
        }

        @Override
        public void print(PrintStream ps) {
            ps.print("STRING(" + this.s + ")");
        }
    }

    public static abstract class Node {
        public abstract void print(PrintStream var1);
    }

    public static class RoundBracketNode
    extends Node {
        protected ContainerNode node;

        private RoundBracketNode(ContainerNode node) {
            this.node = node;
        }

        @Override
        public void print(PrintStream ps) {
            ps.print("ROUND(");
            this.node.print(ps);
            ps.print(")");
        }
    }

    public static class SquareBracketNode
    extends Node {
        protected ContainerNode node;

        private SquareBracketNode(ContainerNode node) {
            this.node = node;
        }

        @Override
        public void print(PrintStream ps) {
            ps.print("SQUARE(");
            this.node.print(ps);
            ps.print(")");
        }
    }

    public static class CommentNode
    extends Node {
        protected String s;

        public CommentNode(String s) {
            this.s = s;
        }

        @Override
        public void print(PrintStream ps) {
            ps.print("COMMENT(" + this.s + ")");
        }
    }
}

