/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xmlcontentfilter;

import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.xmlcontentfilter.SimpleXPathAnalyzer;
import com.predic8.membrane.core.interceptor.xmlcontentfilter.SimpleXPathParser;
import com.predic8.membrane.core.interceptor.xmlcontentfilter.XMLElementFinder;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import com.predic8.membrane.core.util.EndOfStreamException;
import jakarta.mail.internet.ParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@ThreadSafe
public class XMLContentFilter {
    private static final Logger log = LoggerFactory.getLogger(XMLContentFilter.class);
    private final ThreadLocal<XPathExpression> xpe = new ThreadLocal();
    private final ThreadLocal<DocumentBuilder> db = new ThreadLocal();
    private final ThreadLocal<Transformer> t = new ThreadLocal();
    private final XOPReconstitutor xopReconstitutor = new XOPReconstitutor();
    private final String xPath;
    private final XMLElementFinder elementFinder;

    public XMLContentFilter(String xPath) throws XPathExpressionException {
        this.xPath = xPath;
        this.createXPathExpression();
        this.elementFinder = XMLContentFilter.createElementFinder(xPath);
        if (this.elementFinder == null) {
            log.warn("The XPath expression \"" + xPath + "\" could not be optimized to use a StAX parser as a first check. This means that for every SOAP message, a DOM tree has to be built to execute the XPath expression. This might degrade performance significantly.");
        }
    }

    static XMLElementFinder createElementFinder(String xPath) {
        SimpleXPathAnalyzer a = new SimpleXPathAnalyzer();
        List<SimpleXPathParser.ContainerNode> intersectExceptExprs = a.getIntersectExceptExprs(xPath);
        if (intersectExceptExprs == null) {
            return null;
        }
        ArrayList<QName> rootElements = new ArrayList<QName>();
        for (SimpleXPathParser.ContainerNode node : intersectExceptExprs) {
            QName n = a.getElement(node);
            if (n == null) {
                return null;
            }
            rootElements.add(n);
        }
        return new XMLElementFinder(rootElements);
    }

    private XPathExpression createXPathExpression() throws XPathExpressionException {
        XPathExpression res = this.xpe.get();
        if (res != null) {
            return res;
        }
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xp = xpf.newXPath();
        res = xp.compile(this.xPath);
        this.xpe.set(res);
        return res;
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilder res = this.db.get();
        if (res != null) {
            return res;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setExpandEntityReferences(false);
        res = dbf.newDocumentBuilder();
        this.db.set(res);
        return res;
    }

    private Transformer createTransformer() throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        Transformer res = this.t.get();
        if (res != null) {
            return res;
        }
        res = TransformerFactory.newInstance().newTransformer();
        this.t.set(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatchingElements(Message message) {
        try {
            Document d;
            Message xop = null;
            try {
                xop = this.xopReconstitutor.getReconstitutedMessage(message);
            }
            catch (EndOfStreamException | ParseException | FactoryConfigurationError e) {
                log.warn(e.getMessage());
            }
            if (this.elementFinder != null && !this.elementFinder.matches(xop != null ? xop.getBodyAsStream() : message.getBodyAsStream())) {
                return;
            }
            DocumentBuilder db = this.createDocumentBuilder();
            try {
                d = db.parse(xop != null ? xop.getBodyAsStream() : message.getBodyAsStream());
            }
            finally {
                db.reset();
            }
            this.removeElementsIfNecessary(message, xop, d);
        }
        catch (XMLStreamException | SAXException e) {
            log.warn(e.getMessage());
        }
        catch (IOException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | XPathExpressionException e) {
            log.warn(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void removeElementsIfNecessary(Message originalMessage, Message xopDecodedMessage, Document doc) throws XPathExpressionException, TransformerException, TransformerFactoryConfigurationError {
        NodeList toBeDeleted = (NodeList)this.createXPathExpression().evaluate(doc, XPathConstants.NODESET);
        if (toBeDeleted.getLength() > 0) {
            originalMessage.getHeader().removeFields("Content-Encoding");
            if (xopDecodedMessage != null) {
                originalMessage.getHeader().removeFields("Content-Type");
                if (xopDecodedMessage.getHeader().getContentType() != null) {
                    originalMessage.getHeader().setContentType(xopDecodedMessage.getHeader().getContentType());
                }
            }
            for (int i = 0; i < toBeDeleted.getLength(); ++i) {
                Node n = toBeDeleted.item(i);
                n.getParentNode().removeChild(n);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.createTransformer().transform(new DOMSource(doc), new StreamResult(baos));
            originalMessage.setBodyContent(baos.toByteArray());
        }
    }
}

