/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xmlcontentfilter;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.xmlcontentfilter.XMLContentFilter;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="xmlContentFilter")
public class XMLContentFilterInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(XMLContentFilterInterceptor.class);
    private String xPath;
    private XMLContentFilter xmlContentFilter;

    public XMLContentFilterInterceptor() {
        this.name = "xml content filter";
        this.setFlow(Interceptor.Flow.Set.REQUEST_RESPONSE_ABORT_FLOW);
    }

    @Override
    public String getShortDescription() {
        return "Filters out content from messages through XPath expressions.";
    }

    public String getXPath() {
        return this.xPath;
    }

    @MCAttribute
    @Required
    public void setXPath(String xPath) {
        this.xPath = xPath;
        try {
            this.xmlContentFilter = new XMLContentFilter(xPath);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleMessage(exc, exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleMessage(exc, exc.getResponse());
    }

    private Outcome handleMessage(Exchange exc, Message message) {
        try {
            this.xmlContentFilter.removeMatchingElements(message);
            return Outcome.CONTINUE;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).title("XML Error").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }
}

