/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xmlprotection;

import com.predic8.membrane.core.interceptor.xmlprotection.XMLProtectionException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLProtector {
    private static final Logger log = LoggerFactory.getLogger((String)XMLProtector.class.getName());
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private final XMLEventWriter writer;
    private final int maxAttibuteCount;
    private final int maxElementNameLength;
    private final boolean removeDTD;

    public XMLProtector(OutputStreamWriter osw, boolean removeDTD, int maxElementNameLength, int maxAttibuteCount) throws Exception {
        this.writer = XMLOutputFactory.newInstance().createXMLEventWriter(osw);
        this.removeDTD = removeDTD;
        this.maxElementNameLength = maxElementNameLength;
        this.maxAttibuteCount = maxAttibuteCount;
        if (!removeDTD) {
            xmlInputFactory.setProperty("javax.xml.stream.supportDTD", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean protect(InputStreamReader isr) throws XMLProtectionException {
        try {
            XMLEventReader parser;
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                parser = xmlInputFactory.createXMLEventReader(isr);
            }
            while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (event.isStartElement()) {
                    StartElement startElement = (StartElement)event;
                    if (this.maxElementNameLength != -1 && startElement.getName().getLocalPart().length() > this.maxElementNameLength) {
                        log.warn("Element name length: Limit exceeded.");
                        return false;
                    }
                    if (this.maxAttibuteCount != -1) {
                        Iterator<Attribute> i = startElement.getAttributes();
                        int attributeCount = 0;
                        while (i.hasNext()) {
                            if (++attributeCount == this.maxAttibuteCount) {
                                log.warn("Number of attributes per element: Limit exceeded.");
                                return false;
                            }
                            i.next();
                        }
                    }
                }
                if (event instanceof DTD) {
                    DTD dtd = (DTD)event;
                    XMLProtector.checkExternalEntities(dtd);
                    if (this.removeDTD) {
                        log.debug("removed DTD.");
                        continue;
                    }
                }
                this.writer.add(event);
            }
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            log.warn("Received not-wellformed XML.");
            return false;
        }
        return true;
    }

    private static void checkExternalEntities(DTD dtd) throws XMLProtectionException {
        if (XMLProtector.containsExternalEntityReferences(dtd)) {
            String msg = "Possible attack. External entity found in DTD.";
            log.warn(msg);
            throw new XMLProtectionException(msg);
        }
    }

    private static boolean containsExternalEntityReferences(DTD dtd) {
        List<EntityDeclaration> entities = dtd.getEntities();
        if (entities == null || entities.isEmpty()) {
            return false;
        }
        return entities.stream().anyMatch(XMLProtector.isExternalEntity());
    }

    @NotNull
    private static Predicate<EntityDeclaration> isExternalEntity() {
        return ed -> ed.getPublicId() != null || ed.getSystemId() != null;
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
    }
}

