/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xslt;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.xslt.XSLTTransformer;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.TextUtil;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="transform")
public class XSLTInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)XSLTInterceptor.class.getName());
    private String xslt;
    private volatile XSLTTransformer xsltTransformer;
    private final XOPReconstitutor xopr = new XOPReconstitutor();

    public XSLTInterceptor() {
        this.name = "xslt transformer";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        try {
            this.transformMsg(exc.getRequest(), this.xslt, exc.getStringProperties());
        }
        catch (Exception e) {
            ProblemDetails.user(this.router.isProduction(), this.getDisplayName()).detail("Error transforming request!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        try {
            this.transformMsg(exc.getResponse(), this.xslt, exc.getStringProperties());
        }
        catch (Exception e) {
            log.error("Error transforming response!", (Throwable)e);
            ProblemDetails.user(this.router.isProduction(), this.getDisplayName()).detail("Error transforming response!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        return Outcome.CONTINUE;
    }

    private void transformMsg(Message msg, String ss, Map<String, String> parameter) throws Exception {
        if (msg.isBodyEmpty()) {
            return;
        }
        msg.setBodyContent(this.xsltTransformer.transform(new StreamSource(this.xopr.reconstituteIfNecessary(msg)), parameter));
    }

    @Override
    public void init() {
        super.init();
        try {
            this.xsltTransformer = new XSLTTransformer(this.xslt, this.router, XSLTInterceptor.getConcurrency());
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not create XSLT transformer", e);
        }
    }

    private static int getConcurrency() {
        return Runtime.getRuntime().availableProcessors() * 2;
    }

    public String getXslt() {
        return this.xslt;
    }

    @MCAttribute
    public void setXslt(String xslt) {
        this.xslt = xslt;
        this.xsltTransformer = null;
    }

    @Override
    public String getShortDescription() {
        return "Applies an XSLT transformation.";
    }

    @Override
    public String getLongDescription() {
        return String.valueOf(TextUtil.removeFinalChar(this.getShortDescription())) + " using the stylesheet at " + TextUtil.linkURL(this.xslt) + " .";
    }
}

