/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xslt;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.util.TextUtil;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSLTTransformer {
    private static final Logger log = LoggerFactory.getLogger((String)XSLTTransformer.class.getName());
    private final TransformerFactory fac = TransformerFactory.newInstance();
    private final ArrayBlockingQueue<Transformer> transformers;
    private final String styleSheet;

    public XSLTTransformer(String styleSheet, Router router, int concurrency) throws Exception {
        this.styleSheet = styleSheet;
        log.debug("using {} parallel transformer instances for {}", (Object)concurrency, (Object)styleSheet);
        this.transformers = new ArrayBlockingQueue(concurrency);
        this.createOneTransformer(router.getResolverMap(), router.getBaseLocation());
        router.getBackgroundInitializer().execute(() -> {
            try {
                for (int i = 1; i < concurrency; ++i) {
                    this.createOneTransformer(router.getResolverMap(), router.getBaseLocation());
                }
            }
            catch (Exception e) {
                log.error("Error creating XSLT transformer:", (Throwable)e);
            }
        });
    }

    private void createOneTransformer(ResolverMap rr, String baseLocation) throws TransformerConfigurationException, InterruptedException, ResourceRetrievalException {
        Transformer t;
        if (TextUtil.isNullOrEmpty(this.styleSheet)) {
            t = this.fac.newTransformer();
        } else {
            StreamSource source = new StreamSource(rr.resolve(ResolverMap.combine(baseLocation, this.styleSheet)));
            source.setSystemId(this.styleSheet);
            t = this.fac.newTransformer(source);
        }
        this.transformers.put(t);
    }

    public byte[] transform(Source xml) throws Exception {
        return this.transform(xml, new HashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transform(Source xml, Map<String, String> parameters) throws Exception {
        log.debug("applying transformation: {}", (Object)this.styleSheet);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Transformer t = this.transformers.take();
        try {
            try {
                t.clearParameters();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                t.setParameter(e.getKey(), e.getValue());
            }
            t.transform(xml, new StreamResult(baos));
        }
        finally {
            this.transformers.put(t);
        }
        return baos.toByteArray();
    }
}

