/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.jmx;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.jmx.JmxExporter;
import com.predic8.membrane.core.jmx.JmxServiceProxy;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.ServiceProxy;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class JmxRouter {
    private final Router router;
    private final JmxExporter exporter;

    public JmxRouter(Router router, JmxExporter exporter) {
        this.router = router;
        this.exporter = exporter;
        this.exportServiceProxyList();
    }

    @ManagedAttribute
    public String getName() {
        return this.router.getJmx();
    }

    private void exportServiceProxyList() {
        for (Proxy proxy : this.router.getRules()) {
            if (!(proxy instanceof ServiceProxy)) continue;
            this.exportServiceProxy((ServiceProxy)proxy);
        }
    }

    private void exportServiceProxy(ServiceProxy rule) {
        String prefix = "org.membrane-soa:00=serviceProxies, 01=" + this.router.getJmx() + ", name=";
        this.exporter.addBean(prefix + rule.getName().replace(":", ""), new JmxServiceProxy(rule, this.router));
    }
}

