/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.kubernetes;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.spring.k8s.Envelope;
import com.predic8.membrane.core.config.spring.k8s.YamlLoader;
import com.predic8.membrane.core.kubernetes.Bean;
import com.predic8.membrane.core.kubernetes.BeanDefinition;
import com.predic8.membrane.core.kubernetes.BeanRegistry;
import com.predic8.membrane.core.kubernetes.KubernetesWatcher;
import com.predic8.membrane.core.kubernetes.client.WatchAction;
import com.predic8.membrane.core.proxies.Proxy;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanCache
implements BeanRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesWatcher.class);
    private final Router router;
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final ConcurrentHashMap<String, Object> uuidMap = new ConcurrentHashMap();
    private final ArrayBlockingQueue<BeanDefinition> changeEvents = new ArrayBlockingQueue(1000);
    private Thread thread;
    Map<String, BeanDefinition> bds = new HashMap<String, BeanDefinition>();
    Set<String> uidsToActivate = new HashSet<String>();

    public BeanCache(Router router) {
        this.router = router;
    }

    public void start() {
        this.thread = new Thread(() -> {
            while (!Thread.interrupted()) {
                try {
                    BeanDefinition beanDefinition = this.changeEvents.take();
                    this.handle(beanDefinition);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        });
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public Envelope define(Map map) throws IOException {
        String s = this.mapper.writeValueAsString((Object)map).substring(4);
        if (LOG.isDebugEnabled()) {
            LOG.debug("defining bean: {}", (Object)s);
        }
        YamlLoader y = new YamlLoader();
        Envelope envelope = y.load(new StringReader(s), this);
        System.err.println("SUCCESS.");
        return envelope;
    }

    public void handle(WatchAction action, Map m) {
        this.changeEvents.add(new BeanDefinition(action, m));
    }

    void handle(BeanDefinition bd) {
        if (bd.getAction() == WatchAction.DELETED) {
            this.bds.remove(bd.getUid());
        } else {
            this.bds.put(bd.getUid(), bd);
        }
        if (bd.isRule()) {
            this.uidsToActivate.add(bd.getUid());
        }
        if (this.changeEvents.isEmpty()) {
            this.activationRun();
        }
    }

    public void activationRun() {
        System.err.println("---");
        HashSet<String> uidsToRemove = new HashSet<String>();
        for (String uid : this.uidsToActivate) {
            BeanDefinition bd = this.bds.get(uid);
            try {
                Envelope envelope = this.define(bd.getMap());
                bd.setEnvelope(envelope);
                Proxy newProxy = (Proxy)envelope.getSpec();
                try {
                    newProxy.setName(bd.getName());
                    newProxy.init(this.router);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not init rule.", e);
                }
                Proxy oldProxy = null;
                if (bd.getAction() == WatchAction.MODIFIED || bd.getAction() == WatchAction.DELETED) {
                    oldProxy = (Proxy)this.uuidMap.get(bd.getUid());
                }
                if (bd.getAction() == WatchAction.ADDED) {
                    this.router.add(newProxy);
                } else if (bd.getAction() == WatchAction.DELETED) {
                    this.router.getRuleManager().removeRule(oldProxy);
                } else if (bd.getAction() == WatchAction.MODIFIED) {
                    this.router.getRuleManager().replaceRule(oldProxy, newProxy);
                }
                if (bd.getAction() == WatchAction.ADDED || bd.getAction() == WatchAction.MODIFIED) {
                    this.uuidMap.put(bd.getUid(), newProxy);
                }
                if (bd.getAction() == WatchAction.DELETED) {
                    this.uuidMap.remove(bd.getUid());
                }
                uidsToRemove.add(bd.getUid());
            }
            catch (Throwable e) {
                LOG.error("Could not handle " + String.valueOf((Object)bd.getAction()) + " " + bd.getNamespace() + "/" + bd.getName(), e);
            }
        }
        for (String uid : uidsToRemove) {
            this.uidsToActivate.remove(uid);
        }
    }

    @Override
    public Object resolveReference(String url) {
        Optional<BeanDefinition> obd = this.bds.values().stream().filter(bd -> bd.getName().equals(url)).findFirst();
        if (obd.isPresent()) {
            Object spec;
            BeanDefinition bd2 = obd.get();
            Envelope envelope = null;
            if (bd2.getEnvelope() != null) {
                envelope = bd2.getEnvelope();
            }
            if (envelope == null) {
                try {
                    envelope = this.define(bd2.getMap());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (!"prototype".equals(bd2.getScope())) {
                    bd2.setEnvelope(envelope);
                }
            }
            if ((spec = envelope.getSpec()) instanceof Bean) {
                return ((Bean)spec).getBean();
            }
            return spec;
        }
        throw new RuntimeException("Reference " + url + " not found");
    }
}

