/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.kubernetes;

import com.google.common.collect.ImmutableMap;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCOtherAttributes;
import com.predic8.membrane.core.config.spring.K8sHelperGeneratorAutoGenerated;
import com.predic8.membrane.core.config.spring.k8s.YamlLoader;
import com.predic8.membrane.core.kubernetes.BeanRegistry;
import com.predic8.membrane.core.kubernetes.ParserHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

public class GenericYamlParser {
    public static <T> T parse(String context, Class<T> clazz, Iterator<Event> events, BeanRegistry registry) {
        Object obj;
        block23: {
            obj = null;
            try {
                Class<?> wanted;
                obj = clazz.newInstance();
                Event event = events.next();
                if (!(event instanceof MappingStartEvent)) {
                    throw new IllegalStateException("Expected start-of-map in line " + event.getStartMark().getLine() + " column " + event.getStartMark().getColumn());
                }
                while (true) {
                    if (!((event = events.next()) instanceof ScalarEvent)) {
                        if (!(event instanceof MappingEndEvent)) {
                            throw new IllegalStateException("Expected scalar or end-of-map in line " + event.getStartMark().getLine() + " column " + event.getStartMark().getColumn());
                        }
                        break block23;
                    }
                    String key = ((ScalarEvent)event).getValue();
                    if ("$ref".equals(key)) {
                        event = events.next();
                        if (!(event instanceof ScalarEvent)) {
                            throw new IllegalStateException("Expected a string after the '$ref' key.");
                        }
                        Object o = registry.resolveReference(((ScalarEvent)event).getValue());
                        Method setter = GenericYamlParser.getChildSetter(clazz, o.getClass());
                        ParserHelper.setSetter(obj, setter, o);
                        continue;
                    }
                    Method setter = GenericYamlParser.getSetter(clazz, key);
                    Class<?> clazz2 = null;
                    if (setter == null) {
                        try {
                            clazz2 = K8sHelperGeneratorAutoGenerated.getLocal(context, key);
                            if (clazz2 == null) {
                                clazz2 = K8sHelperGeneratorAutoGenerated.elementMapping.get(key);
                            }
                            if (clazz2 != null) {
                                setter = GenericYamlParser.getChildSetter(clazz, clazz2);
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Can't find method or bean for key: " + key + " in " + clazz.getName(), e);
                        }
                        if (setter == null) {
                            setter = GenericYamlParser.getAnySetter(clazz);
                        }
                        if (clazz2 == null && setter == null) {
                            throw new RuntimeException("Can't find method or bean for key: " + key + " in " + clazz.getName());
                        }
                    }
                    if ((wanted = setter.getParameterTypes()[0]).equals(List.class)) {
                        ParserHelper.setSetter(obj, setter, GenericYamlParser.parseList(context, events, registry));
                        continue;
                    }
                    if (wanted.equals(String.class)) {
                        ParserHelper.setSetter(obj, setter, YamlLoader.readString(events));
                        continue;
                    }
                    if (wanted.equals(Integer.TYPE)) {
                        ParserHelper.setSetter(obj, setter, Integer.parseInt(YamlLoader.readString(events)));
                        continue;
                    }
                    if (wanted.equals(Long.TYPE)) {
                        ParserHelper.setSetter(obj, setter, Long.parseLong(YamlLoader.readString(events)));
                        continue;
                    }
                    if (wanted.equals(Boolean.TYPE)) {
                        ParserHelper.setSetter(obj, setter, Boolean.parseBoolean(YamlLoader.readString(events)));
                        continue;
                    }
                    if (wanted.equals(Map.class) && AnnotationUtils.findAnnotation((Method)setter, MCOtherAttributes.class) != null) {
                        ParserHelper.setSetter(obj, setter, ImmutableMap.of((Object)key, (Object)YamlLoader.readString(events)));
                        continue;
                    }
                    if (ParserHelper.isStructured(setter)) {
                        if (clazz2 != null) {
                            ParserHelper.setSetter(obj, setter, GenericYamlParser.parseMapToObj(context, events, event, registry));
                            continue;
                        }
                        ParserHelper.setSetter(obj, setter, GenericYamlParser.parse(context, wanted, events, registry));
                        continue;
                    }
                    if (AnnotationUtils.findAnnotation((Method)setter, MCAttribute.class) == null || AnnotationUtils.findAnnotation(setter.getParameterTypes()[0], MCElement.class) == null) break;
                    ParserHelper.setSetter(obj, setter, registry.resolveReference(YamlLoader.readString(events)));
                }
                throw new RuntimeException("Not implemented setter type " + String.valueOf(wanted));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return obj;
    }

    private static List parseList(String context, Iterator<Event> events, BeanRegistry registry) {
        Event event = events.next();
        if (!(event instanceof SequenceStartEvent)) {
            throw new IllegalStateException("Expected start-of-sequence in line " + event.getStartMark().getLine() + " column " + event.getStartMark().getColumn());
        }
        ArrayList<Object> res = new ArrayList<Object>();
        while (!((event = events.next()) instanceof SequenceEndEvent)) {
            if (!(event instanceof MappingStartEvent)) {
                throw new IllegalStateException("Expected end-of-sequence or begin-of-map in line " + event.getStartMark().getLine() + " column " + event.getStartMark().getColumn());
            }
            Object o = GenericYamlParser.parseMapToObj(context, events, registry);
            res.add(o);
        }
        return res;
    }

    private static Object parseMapToObj(String context, Iterator<Event> events, BeanRegistry registry) {
        Event event = events.next();
        if (!(event instanceof ScalarEvent)) {
            throw new IllegalStateException("Expected scalar in line " + event.getStartMark().getLine() + " column " + event.getStartMark().getColumn());
        }
        Object o = GenericYamlParser.parseMapToObj(context, events, event, registry);
        event = events.next();
        if (!(event instanceof MappingEndEvent)) {
            throw new IllegalStateException("Expected end-of-map or begin-of-map in line " + event.getStartMark().getLine() + " column " + event.getStartMark().getColumn());
        }
        return o;
    }

    private static Object parseMapToObj(String context, Iterator<Event> events, Event event, BeanRegistry registry) {
        String key = ((ScalarEvent)event).getValue();
        if ("$ref".equals(key)) {
            event = events.next();
            if (!(event instanceof ScalarEvent)) {
                throw new IllegalStateException("Expected a string after the '$ref' key.");
            }
            return registry.resolveReference(((ScalarEvent)event).getValue());
        }
        Class<?> clazz = K8sHelperGeneratorAutoGenerated.getLocal(context, key);
        if (clazz == null) {
            clazz = K8sHelperGeneratorAutoGenerated.elementMapping.get(key);
        }
        if (clazz == null) {
            throw new RuntimeException("Did not find java class for key '" + key + "'.");
        }
        return GenericYamlParser.parse(key, clazz, events, registry);
    }

    private static <T> Method getSetter(Class<T> clazz, String key) {
        return Arrays.stream(clazz.getMethods()).filter(ParserHelper::isSetter).filter(method -> ParserHelper.matchesJsonKey(method, key)).findFirst().orElse(null);
    }

    private static <T> Method getAnySetter(Class<T> clazz) {
        return Arrays.stream(clazz.getMethods()).filter(ParserHelper::isSetter).filter(method -> AnnotationUtils.findAnnotation((Method)method, MCOtherAttributes.class) != null).findFirst().orElse(null);
    }

    private static <T> Method getChildSetter(Class<T> clazz, Class<?> valueClass) {
        return Arrays.stream(clazz.getMethods()).filter(ParserHelper::isSetter).filter(method -> method.getParameterTypes().length == 1).filter(method -> method.getParameterTypes()[0].isAssignableFrom(valueClass)).findFirst().orElseThrow(() -> new RuntimeException("Could not find child setter on " + clazz.getName() + " for value of type " + valueClass.getName()));
    }
}

