/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.kubernetes;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.spring.K8sHelperGeneratorAutoGenerated;
import com.predic8.membrane.core.interceptor.kubernetes.KubernetesValidationInterceptor;
import com.predic8.membrane.core.kubernetes.BeanCache;
import com.predic8.membrane.core.kubernetes.client.KubernetesApiException;
import com.predic8.membrane.core.kubernetes.client.KubernetesClient;
import com.predic8.membrane.core.kubernetes.client.WatchAction;
import com.predic8.membrane.core.kubernetes.client.Watcher;
import com.predic8.membrane.core.proxies.Proxy;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesWatcher.class);
    private final Router router;
    private final BeanCache beanCache;
    private KubernetesClient client;
    private ExecutorService executors;
    private ConcurrentHashMap<String, Closeable> watches = new ConcurrentHashMap();

    public KubernetesWatcher(Router router) {
        this.router = router;
        this.beanCache = new BeanCache(router);
    }

    public void start() {
        ArrayList<String> namespaces;
        Optional<KubernetesValidationInterceptor> kvi = this.findK8sValidatingInterceptor();
        if (kvi.isEmpty()) {
            return;
        }
        this.beanCache.start();
        this.client = this.getClient();
        List<String> crds = K8sHelperGeneratorAutoGenerated.crdSingularNames;
        if (kvi.get().getResourcesList().size() > 0) {
            crds = crds.stream().filter(s -> ((KubernetesValidationInterceptor)kvi.get()).getResourcesList().contains(s)).collect(Collectors.toList());
        }
        if (crds.size() > 0) {
            this.executors = Executors.newFixedThreadPool(crds.size());
        }
        if ((namespaces = new ArrayList<String>(kvi.get().getNamespacesList())).size() == 1 && "*".equals(namespaces.get(0))) {
            namespaces.set(0, null);
        }
        crds.forEach(crd -> namespaces.forEach(ns -> this.createWatcher((String)ns, (String)crd)));
    }

    public void stop() {
        this.watches.values().forEach(c -> {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.beanCache.stop();
    }

    private KubernetesClient getClient() {
        return this.router.getKubernetesClientFactory().createClient(null);
    }

    private Optional<KubernetesValidationInterceptor> findK8sValidatingInterceptor() {
        return this.router.getRules().stream().map(Proxy::getInterceptors).filter(Objects::nonNull).flatMap(Collection::stream).filter(inter -> inter instanceof KubernetesValidationInterceptor).map(inter -> (KubernetesValidationInterceptor)inter).findFirst();
    }

    private boolean isInK8sCluster() {
        return System.getenv("KUBERNETES_SERVICE_HOST") != null;
    }

    private void createWatcher(final String namespace, final String crd) {
        try {
            this.watches.put(namespace + "/" + crd, this.client.watch("membrane-soa.org/v1beta1", crd, namespace, null, this.executors, new Watcher(){

                @Override
                public void onEvent(WatchAction action, Map m) {
                    try {
                        System.err.println(String.valueOf((Object)action) + " " + crd + " " + String.valueOf(((Map)m.get("metadata")).get("namespace")) + "/" + String.valueOf(((Map)m.get("metadata")).get("name")));
                        KubernetesWatcher.this.beanCache.handle(action, m);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onClosed(@Nullable Throwable t) {
                    LOG.error("Watcher for " + crd + " closed unexpectedly, restarting...", t);
                    KubernetesWatcher.this.createWatcher(namespace, crd);
                }
            }));
            LOG.debug("Added Watcher for {}", (Object)crd);
        }
        catch (KubernetesApiException | IOException e) {
            e.printStackTrace();
        }
    }

    private String getUid(JSONObject json) {
        JSONObject metadata = new JSONObject((Map)json.get((Object)"metadata"));
        return (String)metadata.get((Object)"uid");
    }

    private String lowerFirstChar(String str) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }
}

